"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const common_1 = require("@nestjs/common");
const app_controller_1 = require("./app.controller");
const app_service_1 = require("./app.service");
const axios_1 = require("@nestjs/axios");
const config_1 = require("@nestjs/config");
const jwt_1 = require("@nestjs/jwt");
const platform_express_1 = require("@nestjs/platform-express");
const typeorm_1 = require("@nestjs/typeorm");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const index_entities_1 = require("./entities/index.entities");
const environment_service_1 = require("./services/environment.service");
const index_controllers_1 = require("./controllers/index.controllers");
const index_service_1 = require("./services/index.service");
const jwt_auth_guard_1 = require("./modules/authentication/guards/jwt-auth.guard");
const authentication_module_1 = require("./modules/authentication/authentication.module");
const index_repository_1 = require("./repositories/index.repository");
const video_module_1 = require("./modules/video/video.module");
const content_group_module_1 = require("./modules/content-group/content-group.module");
const storage_module_1 = require("./modules/storage/storage.module");
const content_module_1 = require("./modules/content/content.module");
const content_schedule_module_1 = require("./modules/content-schedule/content-schedule.module");
const schedule_1 = require("@nestjs/schedule");
const poster_module_1 = require("./modules/poster/poster.module");
const cache_manager_1 = require("@nestjs/cache-manager");
const channel_pricing_module_1 = require("./modules/channel-pricing/channel-pricing.module");
const subscription_module_1 = require("./modules/subscription/subscription.module");
const channel_module_1 = require("./modules/channel/channel.module");
const content_category_module_1 = require("./modules/content-category/content-category.module");
const content_favourite_module_1 = require("./modules/content-favourite/content-favourite.module");
const config_module_1 = require("./modules/config/config.module");
const pricing_module_1 = require("./modules/pricing/pricing.module");
const view_history_module_1 = require("./modules/view-history/view-history.module");
const paystack_service_1 = require("./services/paystack.service");
let AppModule = class AppModule {
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_1.Module)({
        imports: [
            la_nest_library_1.LaLibraryModule,
            authentication_module_1.AuthenticationModule,
            la_nest_library_1.SDKNotificationModule,
            la_nest_library_1.SDKFileModule,
            video_module_1.VideoModule,
            config_1.ConfigModule.forRoot({
                isGlobal: true,
                expandVariables: true,
            }),
            typeorm_1.TypeOrmModule.forRootAsync({
                extraProviders: [environment_service_1.EnvironmentService],
                inject: [environment_service_1.EnvironmentService],
                useFactory: () => {
                    return {
                        type: 'mysql',
                        host: environment_service_1.evt.DATABASE_HOST,
                        port: environment_service_1.evt.DATABASE_PORT,
                        username: environment_service_1.evt.DATABASE_USERNAME,
                        password: environment_service_1.evt.DATABASE_PASSWORD,
                        database: environment_service_1.evt.DATABASE_NAME,
                        synchronize: environment_service_1.evt.SYNCHRONIZE,
                        entities: index_entities_1.entities,
                        retryAttempts: 0,
                        timezone: '+01:00',
                        driver: require('mysql2'),
                        extra: {},
                    };
                },
            }),
            typeorm_1.TypeOrmModule.forFeature(index_entities_1.entities),
            jwt_1.JwtModule.registerAsync({
                global: true,
                useClass: environment_service_1.EnvironmentService,
            }),
            platform_express_1.MulterModule.registerAsync({
                useClass: environment_service_1.EnvironmentService,
            }),
            axios_1.HttpModule,
            la_nest_library_1.SDKLogsModule,
            la_nest_library_1.WordpressModule,
            la_nest_library_1.SDKWalletModule,
            storage_module_1.StorageModule,
            content_group_module_1.ContentGroupModule,
            la_nest_library_1.LoggerDBModule,
            content_schedule_module_1.ContentScheduleModule,
            poster_module_1.PosterModule,
            content_module_1.ContentModule,
            schedule_1.ScheduleModule.forRoot(),
            cache_manager_1.CacheModule.register({
                ttl: 3600000,
                isGlobal: true,
            }),
            channel_pricing_module_1.ChannelPricingModule,
            subscription_module_1.SubscriptionModule,
            channel_module_1.ChannelModule,
            content_category_module_1.ContentCategoryModule,
            content_favourite_module_1.ContentFavouriteModule,
            config_module_1.ConfigModule,
            pricing_module_1.PricingModule,
            view_history_module_1.ViewHistoryModule,
            paystack_service_1.PaystackServiceModule,
        ],
        controllers: [app_controller_1.AppController, ...index_controllers_1.Controllers],
        providers: [
            app_service_1.AppService,
            environment_service_1.EnvironmentService,
            ...index_service_1.Services,
            ...index_repository_1.Repositories,
            jwt_auth_guard_1.JwtAuthGuard.provideGuard(),
            la_nest_library_1.LoggerDBModule.provideEndpointLoggerInterceptor(),
        ],
        exports: [...index_service_1.Services],
    })
], AppModule);
//# sourceMappingURL=app.module.js.map