"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DashboardController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const utility_service_1 = require("../services/utility.service");
const dashboard_service_1 = require("../services/dashboard.service");
const jwt_auth_guard_1 = require("../modules/authentication/guards/jwt-auth.guard");
const authentication_enum_1 = require("../modules/authentication/enums/authentication.enum");
let DashboardController = class DashboardController {
    constructor(service) {
        this.service = service;
    }
    async getAdminDashboard() {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getAdminDashboard(),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.DashboardController = DashboardController;
__decorate([
    (0, common_1.Get)(`admin`),
    (0, jwt_auth_guard_1.Role)(authentication_enum_1.EAuthType.admin),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], DashboardController.prototype, "getAdminDashboard", null);
exports.DashboardController = DashboardController = __decorate([
    (0, swagger_1.ApiTags)(dashboard_service_1.DashboardService.path.tag),
    (0, common_1.Controller)(dashboard_service_1.DashboardService.path.path),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [dashboard_service_1.DashboardService])
], DashboardController);
//# sourceMappingURL=dashboard.controller.js.map