"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ErrorController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const utility_service_1 = require("../services/utility.service");
const error_service_1 = require("../services/error.service");
const error_enum_1 = require("../enums/error.enum");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const error_dto_1 = require("../dtos/error.dto");
let ErrorController = class ErrorController {
    constructor(service) {
        this.service = service;
    }
    async actions() {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: utility_service_1.UtilityClass.returnEnum(error_enum_1.EErrorAction),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getTeamCurrentState(query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.fix(query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.ErrorController = ErrorController;
__decorate([
    (0, common_1.Get)('actions'),
    (0, la_nest_library_1.SDKPublicAuth)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ErrorController.prototype, "actions", null);
__decorate([
    (0, common_1.Post)('fix/:action'),
    __param(0, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [error_dto_1.FixErrorDTO]),
    __metadata("design:returntype", Promise)
], ErrorController.prototype, "getTeamCurrentState", null);
exports.ErrorController = ErrorController = __decorate([
    (0, swagger_1.ApiTags)(error_service_1.ErrorService.tag),
    (0, common_1.Controller)(error_service_1.ErrorService.path),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [error_service_1.ErrorService])
], ErrorController);
//# sourceMappingURL=error.controller.js.map