import { IDDto } from '@serene-dev/la-nest-library';
import { BaseCRUDController } from '@serene-dev/la-nest-library/dist/libs/la-library/src/controllers/base.controller';
import { PartnerEntity } from '../../entities/partner.entity';
import { CreatePartnerDTO, SearchPartnerDTO, UpdatePartnerDTO } from '../../dtos/partner.dto';
import { PartnerService } from '../../services/partner/partner.service';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
export declare abstract class PartnerController<TSearchDto extends SearchPartnerDTO = SearchPartnerDTO> extends BaseCRUDController<PartnerEntity, TSearchDto> {
    protected service: PartnerService<TSearchDto>;
    constructor(service: PartnerService<TSearchDto>);
    adminChecker(auth: IAuthParam): void;
    search(query: SearchPartnerDTO, auth?: IAuthParam): Promise<string | import("@serene-dev/la-nest-library").ISearchResponse<PartnerEntity>>;
    create(body: CreatePartnerDTO, auth: IAuthParam): string | Promise<PartnerEntity>;
    updateByID(param: IDDto, body: UpdatePartnerDTO, auth: IAuthParam): string | Promise<PartnerEntity>;
}
