"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProviderController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const partner_controller_1 = require("./partner.controller");
const provider_service_1 = require("../../services/partner/provider.service");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const utility_service_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/services/utility.service");
const base_dto_1 = require("../../dtos/base.dto");
const wallet_dto_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/modules/wallet/wallet.dto");
let ProviderController = class ProviderController extends partner_controller_1.PartnerController {
    constructor(service) {
        super(service);
        this.service = service;
    }
    async shortCodeAnalysis(auth, id) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.generateKeyExt(auth, id.id),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getWallet(auth, id) {
        try {
            this.adminChecker(auth);
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getOrCreateWallet(id.id),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async topupWallet(auth, id, body) {
        try {
            this.adminChecker(auth);
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.topupWallet(id.id, body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.ProviderController = ProviderController;
__decorate([
    (0, common_1.Post)(':id/apiKey'),
    (0, swagger_1.ApiResponse)({ type: base_dto_1.GenericResponseDto }),
    __param(0, (0, la_nest_library_1.AuthParam)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, la_nest_library_1.IDDto]),
    __metadata("design:returntype", Promise)
], ProviderController.prototype, "shortCodeAnalysis", null);
__decorate([
    (0, common_1.Get)(':id/wallet'),
    __param(0, (0, la_nest_library_1.AuthParam)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, la_nest_library_1.IDDto]),
    __metadata("design:returntype", Promise)
], ProviderController.prototype, "getWallet", null);
__decorate([
    (0, common_1.Post)(':id/wallet/topup'),
    __param(0, (0, la_nest_library_1.AuthParam)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, la_nest_library_1.IDDto,
        wallet_dto_1.CreateWalletTransactionDTO]),
    __metadata("design:returntype", Promise)
], ProviderController.prototype, "topupWallet", null);
exports.ProviderController = ProviderController = __decorate([
    (0, swagger_1.ApiTags)(provider_service_1.ProviderService.tag),
    (0, common_1.Controller)(provider_service_1.ProviderService.path),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [provider_service_1.ProviderService])
], ProviderController);
//# sourceMappingURL=provider.controller.js.map