"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GenericResponseDto = exports.IDQueryDto = exports.SetupDTO = exports.SetOrderDTO = exports.ToggleBulkActiveDTO = exports.ToggleActiveDTO = exports.BaseDto = void 0;
const swagger_1 = require("@nestjs/swagger");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
class BaseDto extends la_nest_library_1.SDKBaseDto {
}
exports.BaseDto = BaseDto;
class ToggleActiveDTO {
}
exports.ToggleActiveDTO = ToggleActiveDTO;
__decorate([
    (0, class_validator_1.IsBoolean)(),
    (0, swagger_1.ApiProperty)({ type: 'boolean', default: true }),
    __metadata("design:type", Boolean)
], ToggleActiveDTO.prototype, "active", void 0);
class ToggleBulkActiveDTO extends ToggleActiveDTO {
}
exports.ToggleBulkActiveDTO = ToggleBulkActiveDTO;
__decorate([
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.IsString)({ each: true }),
    (0, class_validator_1.ArrayMinSize)(1),
    (0, swagger_1.ApiProperty)({}),
    __metadata("design:type", Array)
], ToggleBulkActiveDTO.prototype, "ids", void 0);
class SetOrderItem {
}
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SetOrderItem.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], SetOrderItem.prototype, "order", void 0);
class SetOrderDTO {
}
exports.SetOrderDTO = SetOrderDTO;
__decorate([
    (0, swagger_1.ApiProperty)({ type: [SetOrderItem] }),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => SetOrderItem),
    __metadata("design:type", Array)
], SetOrderDTO.prototype, "items", void 0);
class SetupDTO {
}
exports.SetupDTO = SetupDTO;
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", String)
], SetupDTO.prototype, "batchID", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsBoolean)(),
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", Boolean)
], SetupDTO.prototype, "override", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.IsString)({ each: true }),
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", Array)
], SetupDTO.prototype, "customSeasonIDs", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.IsString)({ each: true }),
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", Array)
], SetupDTO.prototype, "gamePeriodIDs", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.IsString)({ each: true }),
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", Array)
], SetupDTO.prototype, "countryIDs", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.IsString)({ each: true }),
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", Array)
], SetupDTO.prototype, "leagueIDs", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.IsString)({ each: true }),
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", Array)
], SetupDTO.prototype, "teamIDs", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.IsString)({ each: true }),
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", Array)
], SetupDTO.prototype, "playerIDs", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.IsString)({ each: true }),
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", Array)
], SetupDTO.prototype, "fixtureIDs", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", String)
], SetupDTO.prototype, "startDate", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", String)
], SetupDTO.prototype, "endDate", void 0);
class IDQueryDto extends (0, swagger_1.PartialType)(la_nest_library_1.IDDto) {
}
exports.IDQueryDto = IDQueryDto;
class GenericResponseDto {
}
exports.GenericResponseDto = GenericResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], GenericResponseDto.prototype, "message", void 0);
//# sourceMappingURL=base.dto.js.map