"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssignPlanDto = exports.GetClientWalletDto = exports.SearchProviderDTO = exports.SearchPartnerDTO = exports.UpdatePartnerDTO = exports.CreatePartnerDTO = void 0;
const class_validator_1 = require("class-validator");
const swagger_1 = require("@nestjs/swagger");
const base_entity_1 = require("../entities/base.entity");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
class CreatePartnerDTO {
}
exports.CreatePartnerDTO = CreatePartnerDTO;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreatePartnerDTO.prototype, "phoneNumber", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreatePartnerDTO.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], CreatePartnerDTO.prototype, "name", void 0);
class UpdatePartnerDTO extends (0, swagger_1.PartialType)(CreatePartnerDTO) {
}
exports.UpdatePartnerDTO = UpdatePartnerDTO;
class SearchPartnerDTO extends (0, swagger_1.IntersectionType)(base_entity_1.SearchQueryDto, UpdatePartnerDTO) {
}
exports.SearchPartnerDTO = SearchPartnerDTO;
class SearchProviderDTO extends (0, swagger_1.IntersectionType)(base_entity_1.SearchQueryDto, UpdatePartnerDTO) {
}
exports.SearchProviderDTO = SearchProviderDTO;
class GetClientWalletDto {
}
exports.GetClientWalletDto = GetClientWalletDto;
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], GetClientWalletDto.prototype, "grossBalance", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], GetClientWalletDto.prototype, "netBalance", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], GetClientWalletDto.prototype, "grossTotalCredit", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], GetClientWalletDto.prototype, "grossTotalDebit", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], GetClientWalletDto.prototype, "netTotalCredit", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], GetClientWalletDto.prototype, "netTotalDebit", void 0);
class AssignPlanDto extends la_nest_library_1.IDDto {
}
exports.AssignPlanDto = AssignPlanDto;
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsUUID)(),
    __metadata("design:type", String)
], AssignPlanDto.prototype, "productID", void 0);
//# sourceMappingURL=partner.dto.js.map