"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.entities = exports.views = void 0;
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const token_session_entity_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/entities/token-session.entity");
const partner_entity_1 = require("./partner.entity");
const authentication_module_1 = require("../modules/authentication/authentication.module");
const video_module_1 = require("../modules/video/video.module");
const admin_dashboard_entity_1 = require("./views/dashboard/admin-dashboard.entity");
const content_group_module_1 = require("../modules/content-group/content-group.module");
const storage_module_1 = require("../modules/storage/storage.module");
const content_module_1 = require("../modules/content/content.module");
const content_schedule_module_1 = require("../modules/content-schedule/content-schedule.module");
const poster_module_1 = require("../modules/poster/poster.module");
const channel_pricing_module_1 = require("../modules/channel-pricing/channel-pricing.module");
const config_module_1 = require("../modules/config/config.module");
const channel_module_1 = require("../modules/channel/channel.module");
const content_category_module_1 = require("../modules/content-category/content-category.module");
const content_favourite_module_1 = require("../modules/content-favourite/content-favourite.module");
const subscription_module_1 = require("../modules/subscription/subscription.module");
const view_history_module_1 = require("../modules/view-history/view-history.module");
const pricing_module_1 = require("../modules/pricing/pricing.module");
exports.views = [admin_dashboard_entity_1.AdminDashboardView];
exports.entities = [
    la_nest_library_1.FileEntity,
    la_nest_library_1.LikesEntity,
    token_session_entity_1.TokenSessionEntity,
    partner_entity_1.PartnerEntity,
    ...authentication_module_1.AuthenticationModule.entities,
    ...channel_module_1.ChannelModule.entities,
    ...channel_pricing_module_1.ChannelPricingModule.entities,
    ...config_module_1.ConfigModule.entities,
    ...content_category_module_1.ContentCategoryModule.entities,
    ...content_favourite_module_1.ContentFavouriteModule.entities,
    ...content_group_module_1.ContentGroupModule.entities,
    ...content_module_1.ContentModule.entities,
    ...content_schedule_module_1.ContentScheduleModule.entities,
    ...la_nest_library_1.LoggerDBModule.entities,
    ...poster_module_1.PosterModule.entities,
    ...pricing_module_1.PricingModule.entities,
    ...la_nest_library_1.SDKFileModule.entities,
    ...la_nest_library_1.SDKWalletModule.entities,
    ...storage_module_1.StorageModule.entities,
    ...subscription_module_1.SubscriptionModule.entities,
    ...video_module_1.VideoModule.entities,
    ...view_history_module_1.ViewHistoryModule.entities,
    ...exports.views,
];
//# sourceMappingURL=index.entities.js.map