"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdminDashboardView = void 0;
const typeorm_1 = require("typeorm");
const base_enum_1 = require("../../../enums/base.enum");
const utility_service_1 = require("../../../services/utility.service");
const partner_enum_1 = require("../../../enums/partner.enum");
const authentication_enum_1 = require("../../../modules/authentication/enums/authentication.enum");
const content_enum_1 = require("../../../enums/content.enum");
const expression = `
   SELECT
    *
FROM
    (
        (
    SELECT
        COUNT(*) as contentCount
    FROM
        ${base_enum_1.ETableName.contents}
    ) AS contentCount,
        (
    SELECT
        COUNT(*) as approvedContentCount
    FROM
        ${base_enum_1.ETableName.contents} c where c.status = '${content_enum_1.EContentStatus.approved}'
    ) AS approvedContentCount,
        (
    SELECT
        COUNT(*) as blockedContentCount
    FROM
        ${base_enum_1.ETableName.contents} c where c.status = '${content_enum_1.EContentStatus.blocked}'
    ) AS blockedContentCount,
        (
    SELECT
        COUNT(*) as inReviewContentCount
    FROM
        ${base_enum_1.ETableName.contents} c where c.status = '${content_enum_1.EContentStatus.in_review}'
    ) AS inReviewContentCount,
    (
SELECT
    COUNT(*) AS channelCount
FROM
        ${base_enum_1.ETableName.channels}
) AS channelCount,
(
    SELECT
        COUNT(*) AS publicUserCount
    FROM
        ${base_enum_1.ETableName.authentication} a
    WHERE
        a.type = '${authentication_enum_1.EAuthType.public}'
) AS publicUserCount,
(
    SELECT
        COUNT(*) AS providerCount
    FROM
        ${base_enum_1.ETableName.partner} p
    WHERE
        p.type = '${partner_enum_1.EPartnerType.provider}'
) AS providerCount
    );`;
let AdminDashboardView = class AdminDashboardView {
};
exports.AdminDashboardView = AdminDashboardView;
__decorate([
    (0, typeorm_1.ViewColumn)({ ...utility_service_1.UtilityClass.transformerNumber }),
    __metadata("design:type", Number)
], AdminDashboardView.prototype, "contentCount", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)({ ...utility_service_1.UtilityClass.transformerNumber }),
    __metadata("design:type", Number)
], AdminDashboardView.prototype, "channelCount", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)({ ...utility_service_1.UtilityClass.transformerNumber }),
    __metadata("design:type", Number)
], AdminDashboardView.prototype, "publicUserCount", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)({ ...utility_service_1.UtilityClass.transformerNumber }),
    __metadata("design:type", Number)
], AdminDashboardView.prototype, "providerCount", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)({ ...utility_service_1.UtilityClass.transformerNumber }),
    __metadata("design:type", Number)
], AdminDashboardView.prototype, "approvedContentCount", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)({ ...utility_service_1.UtilityClass.transformerNumber }),
    __metadata("design:type", Number)
], AdminDashboardView.prototype, "blockedContentCount", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)({ ...utility_service_1.UtilityClass.transformerNumber }),
    __metadata("design:type", Number)
], AdminDashboardView.prototype, "inReviewContentCount", void 0);
exports.AdminDashboardView = AdminDashboardView = __decorate([
    (0, typeorm_1.ViewEntity)({
        expression,
        name: base_enum_1.ETableName.dashboard_admin_view,
    })
], AdminDashboardView);
//# sourceMappingURL=admin-dashboard.entity.js.map