"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const app_module_1 = require("./app.module");
const index_config_1 = require("./configs/index.config");
const helmet_1 = require("helmet");
const environment_service_1 = require("./services/environment.service");
const utility_service_1 = require("./services/utility.service");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const dotenv = require("dotenv");
const fs = require("fs");
const path = require("path");
const provider_module_1 = require("./modules/provider/provider.module");
const common_1 = require("@nestjs/common");
const ffmpeg = require("fluent-ffmpeg");
const ffmpegStatic = require("ffmpeg-static");
function getPath(path) {
    const p = __dirname + path;
    return p;
}
let parsedEnv = dotenv.config();
if (parsedEnv.error)
    parsedEnv = dotenv.config({ path: getPath('/.env') });
const _evt = parsedEnv.parsed;
if (ffmpegStatic) {
    const FfmpegPath = _evt.FFMPEG_PATH ?? ffmpegStatic;
    const FFPROBE_PATH = _evt.FFPROBE_PATH;
    console.log('FfmpegPath', FfmpegPath);
    console.log('FFPROBE_PATH', FFPROBE_PATH);
    ffmpeg.setFfmpegPath(FfmpegPath);
    if (FFPROBE_PATH)
        ffmpeg.setFfprobePath(FFPROBE_PATH);
}
async function bootstrap() {
    console.log('logs loc', path.join(__dirname, _evt.LOGS_DEST));
    (0, la_nest_library_1.initLogger)(path.join(__dirname, _evt.LOGS_DEST));
    const app = await core_1.NestFactory.create(app_module_1.AppModule, {
        logger: ['error', 'warn'],
        httpsOptions: !_evt.CA
            ? undefined
            : {
                ca: fs.readFileSync(getPath(_evt.CA)),
                cert: fs.readFileSync(getPath(_evt.CERT)),
                key: fs.readFileSync(getPath(_evt.KEY)),
            },
    });
    app.enableCors();
    app.use((0, helmet_1.default)({
        crossOriginResourcePolicy: { policy: 'cross-origin' },
    }));
    if (environment_service_1.evt.isDev)
        app.useBodyParser('json', { limit: '10mb' });
    app.useGlobalPipes(new common_1.ValidationPipe({
        whitelist: true,
    }));
    try {
        console.log(`Loading Full swagger`);
        utility_service_1.UtilityClass.enableSwagger(app, {
            appName: index_config_1.Config.appName,
            path: `api-docs`,
            docExpansion: 'none',
        });
        utility_service_1.UtilityClass.enableSwagger(app, {
            appName: index_config_1.Config.appName,
            path: `provider-docs`,
            docExpansion: 'none',
            modules: [provider_module_1.ProviderModule],
        });
        console.log(`Loaded Full swagger`);
        console.log('Timezone difference in mins', utility_service_1.UtilityClass.calculateTimeZoneDifferenceMins());
        _evt.timestampDifferenceFromGMT =
            utility_service_1.UtilityClass.calculateTimeZoneDifferenceMilliSec();
        await app.listen(+_evt.SERVER_PORT);
        _evt.SERVER_URL = _evt.SERVER_URL || (await app.getUrl());
        console.log(`Application is running on: ${_evt.SERVER_URL}`);
        la_nest_library_1.MailService.loadConfigFromEnvironment(_evt);
        console.log(`Loaded SMTP credentials`);
    }
    catch (error) {
        debugger;
        la_nest_library_1.MailService.sendCrashNotification(error);
        console.error(error);
    }
}
bootstrap();
//# sourceMappingURL=main.js.map