"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthenticationModule = void 0;
const common_1 = require("@nestjs/common");
const authentication_service_1 = require("./services/authentication.service");
const typeorm_1 = require("@nestjs/typeorm");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const authentication_entity_1 = require("./entities/authentication.entity");
const user_detail_entity_1 = require("./entities/user-detail.entity");
const jwt_auth_guard_1 = require("./guards/jwt-auth.guard");
const admin_users_controller_1 = require("./controllers/admin-users.controller");
const admin_users_service_1 = require("./services/admin-users.service");
const authentication_session_entity_1 = require("./entities/authentication-session.entity");
const shared_service_1 = require("../../services/shared.service");
const public_users_service_1 = require("./services/public-users.service");
const public_users_controller_1 = require("./controllers/public-users.controller");
const authentication_repository_1 = require("./services/authentication.repository");
const provider_users_service_1 = require("./services/provider-users.service");
const provider_users_controller_1 = require("./controllers/provider-users.controller");
const providers = [
    authentication_service_1.AuthService,
    ...shared_service_1.SharedServices,
    authentication_service_1.AuthenticationSessionService,
    jwt_auth_guard_1.JwtAuthGuard,
    admin_users_service_1.AdminUsersService,
    public_users_service_1.PublicUsersService,
    authentication_repository_1.AuthRepository,
    provider_users_service_1.ProviderUsersService,
];
let AuthenticationModule = class AuthenticationModule extends la_nest_library_1.BaseModule {
};
exports.AuthenticationModule = AuthenticationModule;
AuthenticationModule.entities = [
    authentication_session_entity_1.AuthSessionEntity,
    authentication_entity_1.AuthEntity,
    la_nest_library_1.SDKAuthEntity,
    user_detail_entity_1.UserDetailEntity,
    la_nest_library_1.SDKTokenSessionEntity,
    user_detail_entity_1.UserView,
];
AuthenticationModule.services = providers;
exports.AuthenticationModule = AuthenticationModule = __decorate([
    (0, common_1.Module)({
        imports: [
            la_nest_library_1.SDKWalletModule,
            typeorm_1.TypeOrmModule.forFeature(AuthenticationModule.entities),
        ],
        providers: [...providers],
        exports: [...providers],
        controllers: [
            admin_users_controller_1.AdminUsersController,
            public_users_controller_1.PublicUsersController,
            provider_users_controller_1.ProviderUsersController,
        ],
    })
], AuthenticationModule);
//# sourceMappingURL=authentication.module.js.map