"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProviderUsersController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const users_controller_1 = require("./users.controller");
const authentication_enum_1 = require("../enums/authentication.enum");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const authentication_dto_1 = require("../dtos/authentication.dto");
const authentication_service_1 = require("../services/authentication.service");
const base_dto_1 = require("../../../dtos/base.dto");
const provider_users_service_1 = require("../services/provider-users.service");
const utility_service_1 = require("../../../services/utility.service");
let ProviderUsersController = class ProviderUsersController extends users_controller_1.UsersController {
    constructor(service, authService) {
        super(service, authService);
        this.service = service;
        this.authService = authService;
        this.subject = `${authentication_enum_1.EAuthType.provider} User`;
    }
    async register(data) {
        try {
            const login = data.login == true;
            data.login = false;
            const res = await this.createFunc(data, await this.service.createUser(data));
            return utility_service_1.UtilityClass.handleSuccess({
                data: login
                    ? await this.service.login({
                        email: data.email,
                        orgID: data.orgID,
                        password: data.password,
                    })
                    : res,
                message: `${this.subject} signed up`,
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getWallet(auth, query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getOrCreateWallet(utility_service_1.UtilityClass.isAdmin(auth) ? query.id : auth.id),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.ProviderUsersController = ProviderUsersController;
__decorate([
    (0, la_nest_library_1.SDKPublicAuth)(),
    (0, common_1.Post)('register'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [authentication_dto_1.RegisterUserDTO]),
    __metadata("design:returntype", Promise)
], ProviderUsersController.prototype, "register", null);
__decorate([
    (0, common_1.Get)('wallet'),
    __param(0, (0, la_nest_library_1.AuthParam)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, base_dto_1.IDQueryDto]),
    __metadata("design:returntype", Promise)
], ProviderUsersController.prototype, "getWallet", null);
exports.ProviderUsersController = ProviderUsersController = __decorate([
    (0, swagger_1.ApiTags)(provider_users_service_1.ProviderUsersService.tag),
    (0, common_1.Controller)(provider_users_service_1.ProviderUsersService.path),
    __metadata("design:paramtypes", [provider_users_service_1.ProviderUsersService,
        authentication_service_1.AuthService])
], ProviderUsersController);
//# sourceMappingURL=provider-users.controller.js.map