import { UsersController } from './users.controller';
import { PublicUsersService } from '../services/public-users.service';
import { RegisterUserDTO } from '../dtos/authentication.dto';
import { AuthService } from '../services/authentication.service';
import { IAuthParam } from '../interfaces/authentication.interface';
import { IDQueryDto } from '../../../dtos/base.dto';
import { VerifyResetPasswordTokenResponseDTO } from '@serene-dev/la-nest-library/dist/libs/la-library/src/modules/authentication/authentication.dto';
export declare class PublicUsersController extends UsersController {
    service: PublicUsersService;
    authService: AuthService;
    constructor(service: PublicUsersService, authService: AuthService);
    register(data: RegisterUserDTO): Promise<any>;
    doesEmaiExist(query: VerifyResetPasswordTokenResponseDTO): Promise<string | {
        exists: boolean;
    }>;
    getWallet(auth: IAuthParam, query: IDQueryDto): Promise<string | import("@serene-dev/la-nest-library").SDKWalletEntity>;
}
