import { AuthService } from '../services/authentication.service';
import { LoginDto, CreateUserDTO, UserSearchQueryDTO, UpdateUserDTO } from '../dtos/authentication.dto';
import { UsersService } from '../services/users.service';
import { BaseController } from 'src/controllers/base.controller';
import { UserDetailEntity } from '../entities/user-detail.entity';
import { IDDto, SDKRequestPasswordResetDTO, SDKResetPasswordDTO, SDKSystemLogoutDTO, SDKVerifyResetPasswordTokenDTO } from '@serene-dev/la-nest-library';
import { ToggleActiveDTO } from 'src/dtos/base.dto';
import { IAuthParam } from '../interfaces/authentication.interface';
export declare abstract class UsersController extends BaseController<UserDetailEntity, UserSearchQueryDTO> {
    service: UsersService;
    authService: AuthService;
    subject: string;
    constructor(service: UsersService, authService: AuthService);
    loginFunc: (req: LoginDto, res: UserDetailEntity) => Promise<any>;
    createFunc: (req: UpdateUserDTO, res: UserDetailEntity) => Promise<any>;
    search(query: UserSearchQueryDTO, auth: IAuthParam): Promise<string | import("@serene-dev/la-nest-library").ISearchResponse<UserDetailEntity>>;
    login(data: LoginDto): Promise<any>;
    create(data: CreateUserDTO): Promise<any>;
    forceLogout(body: SDKSystemLogoutDTO): Promise<boolean>;
    logout(param: IAuthParam): Promise<string | boolean>;
    update(data: UpdateUserDTO, param: IDDto): Promise<any>;
    toggleStatus(data: ToggleActiveDTO, param: IDDto): Promise<string | import("../entities/authentication.entity").AuthEntity>;
    requestPasswordReset(body: SDKRequestPasswordResetDTO): Promise<string | {
        message: string;
    }>;
    verifyResetPasswordToken(body: SDKVerifyResetPasswordTokenDTO): Promise<string | import("@serene-dev/la-nest-library/dist/libs/la-library/src/modules/authentication/authentication.service").IPasswordResetTokenObj>;
    resetPassword(body: SDKResetPasswordDTO): Promise<string | {
        message: string;
    }>;
    getByAuthID(data: IDDto): Promise<string | UserDetailEntity>;
    getMyProfile(auth: IAuthParam): Promise<string | UserDetailEntity>;
    genders(): Promise<string | import("@serene-dev/la-nest-library").ValueLabelDto<any>[]>;
}
