import { SDKLoginDTO, SDKRegisterDTO, SDKWalletEntity, SearchQueryDto } from '@serene-dev/la-nest-library';
import { UserBankAccount } from '../entities/authentication.entity';
import { UserDetailEntity, UserView } from '../entities/user-detail.entity';
import { EGender } from '../interfaces/authentication.interface';
import { EAuthType } from '../enums/authentication.enum';
export declare class LoginDto extends SDKLoginDTO {
}
export declare class SaveUserBankAccountDto implements UserBankAccount {
    number: string;
    name: string;
    bankName: string;
    bankSortCode?: string;
    bankCode: string;
}
export declare class RegisterUserDTO extends SDKRegisterDTO implements Partial<UserDetailEntity> {
    phoneNumber?: string;
    gender?: EGender;
    dob?: string;
    type: EAuthType;
    bankAccount?: SaveUserBankAccountDto;
}
export declare class CreateUserDTO extends RegisterUserDTO {
    password?: string;
    wallet?: SDKWalletEntity;
    dob?: string;
    partnerId?: string;
}
declare const UpdateUserDTO_base: import("@nestjs/common").Type<Partial<CreateUserDTO>>;
export declare class UpdateUserDTO extends UpdateUserDTO_base {
}
declare const UserSearchQueryDTO_base: import("@nestjs/common").Type<SearchQueryDto<unknown>>;
export declare class UserSearchQueryDTO extends UserSearchQueryDTO_base implements Partial<UserView> {
    name?: string;
    partnerName?: string;
    firstname?: string;
    lastname?: string;
    email?: string;
    username?: string;
}
export {};
