import { WalletEntity } from '@serene-dev/la-nest-library/dist/libs/la-library/src/modules/wallet/wallet.entity';
import { Relation } from 'typeorm';
import { BaseEntity } from '../../../entities/base.entity';
import { EAuthType } from '../enums/authentication.enum';
import { EGender } from '../interfaces/authentication.interface';
import { UserBankAccount, AuthEntity } from './authentication.entity';
import { PartnerEntity } from '../../../entities/partner.entity';
import { BaseView } from '@serene-dev/la-nest-library';
export declare class UserDetailEntity extends BaseEntity {
    socialId: string;
    phoneNumber: string;
    gender: EGender;
    type: EAuthType;
    manager?: boolean;
    bankAccount?: UserBankAccount;
    firstname?: string;
    lastname?: string;
    dob?: string;
    authId?: string;
    walletId?: string;
    partnerId?: string;
    avatarId?: string;
    ownerId?: string;
    auth?: Relation<AuthEntity>;
    wallet?: Relation<WalletEntity>;
    partner?: Relation<PartnerEntity>;
    owner?: Relation<PartnerEntity>;
}
export declare class UserView extends BaseView {
    email: string;
    signUpType: string;
    partnerName: string;
    firstname?: string;
    lastname?: string;
    name?: string;
    socialId: string;
    phoneNumber: string;
    gender: EGender;
    type: EAuthType;
    manager?: boolean;
    dob?: string;
    authId?: string;
    walletId?: string;
    partnerId?: string;
    ownerId?: string;
}
