"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserView = exports.UserDetailEntity = void 0;
const wallet_entity_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/modules/wallet/wallet.entity");
const typeorm_1 = require("typeorm");
const base_entity_1 = require("../../../entities/base.entity");
const base_enum_1 = require("../../../enums/base.enum");
const authentication_enum_1 = require("../enums/authentication.enum");
const authentication_interface_1 = require("../interfaces/authentication.interface");
const authentication_entity_1 = require("./authentication.entity");
const partner_entity_1 = require("../../../entities/partner.entity");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const utility_service_1 = require("../../../services/utility.service");
let UserDetailEntity = class UserDetailEntity extends base_entity_1.BaseEntity {
};
exports.UserDetailEntity = UserDetailEntity;
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], UserDetailEntity.prototype, "socialId", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], UserDetailEntity.prototype, "phoneNumber", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: authentication_interface_1.EGender, nullable: true }),
    __metadata("design:type", String)
], UserDetailEntity.prototype, "gender", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: authentication_enum_1.EAuthType, default: authentication_enum_1.EAuthType.public }),
    __metadata("design:type", String)
], UserDetailEntity.prototype, "type", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'boolean', default: false }),
    __metadata("design:type", Boolean)
], UserDetailEntity.prototype, "manager", void 0);
__decorate([
    (0, typeorm_1.Column)(() => authentication_entity_1.UserBankAccount),
    __metadata("design:type", authentication_entity_1.UserBankAccount)
], UserDetailEntity.prototype, "bankAccount", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'timestamp', nullable: true }),
    __metadata("design:type", String)
], UserDetailEntity.prototype, "dob", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], UserDetailEntity.prototype, "authId", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], UserDetailEntity.prototype, "walletId", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], UserDetailEntity.prototype, "partnerId", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], UserDetailEntity.prototype, "avatarId", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], UserDetailEntity.prototype, "ownerId", void 0);
__decorate([
    (0, typeorm_1.OneToOne)(() => authentication_entity_1.AuthEntity, (user) => user.detail),
    (0, typeorm_1.JoinColumn)(),
    __metadata("design:type", Object)
], UserDetailEntity.prototype, "auth", void 0);
__decorate([
    (0, typeorm_1.OneToOne)(() => wallet_entity_1.WalletEntity),
    (0, typeorm_1.JoinColumn)({ referencedColumnName: 'id', name: 'walletId' }),
    __metadata("design:type", Object)
], UserDetailEntity.prototype, "wallet", void 0);
__decorate([
    (0, typeorm_1.OneToOne)(() => partner_entity_1.PartnerEntity, (i) => i.manager),
    (0, typeorm_1.JoinColumn)(),
    __metadata("design:type", Object)
], UserDetailEntity.prototype, "partner", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => partner_entity_1.PartnerEntity, (i) => i.users),
    __metadata("design:type", Object)
], UserDetailEntity.prototype, "owner", void 0);
exports.UserDetailEntity = UserDetailEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.userDetail)
], UserDetailEntity);
let UserView = class UserView extends la_nest_library_1.BaseView {
};
exports.UserView = UserView;
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], UserView.prototype, "email", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], UserView.prototype, "signUpType", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], UserView.prototype, "partnerName", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], UserView.prototype, "firstname", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], UserView.prototype, "lastname", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], UserView.prototype, "name", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], UserView.prototype, "socialId", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], UserView.prototype, "phoneNumber", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], UserView.prototype, "gender", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], UserView.prototype, "type", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(utility_service_1.UtilityClass.transformerBoolean),
    __metadata("design:type", Boolean)
], UserView.prototype, "manager", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], UserView.prototype, "dob", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], UserView.prototype, "authId", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], UserView.prototype, "walletId", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], UserView.prototype, "partnerId", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], UserView.prototype, "ownerId", void 0);
exports.UserView = UserView = __decorate([
    (0, typeorm_1.ViewEntity)({
        expression: `
  SELECT
  CONCAT(a.firstname,' ',a.lastname) as name,
	a.firstname,
    a.lastname,
    a.email,
    a.signUpType,
    p.name as partnerName,
    ud.*
FROM
    user_detail ud
LEFT JOIN authentication a ON
    a.id = ud.authId
LEFT JOIN ${base_enum_1.ETableName.partner} p ON 
    p.id = ud.orgID
WHERE
    ud.deletedAt IS NULL;
  `,
        name: base_enum_1.ETableName.users_view,
    })
], UserView);
//# sourceMappingURL=user-detail.entity.js.map