import { SDKAuthenticationService, SDKAuthenticationSessionService, SDKLoginDTO, SDKRegisterDTO, SDKTokenService, SDKTokenSessionService } from '@serene-dev/la-nest-library';
import { Repository } from 'typeorm';
import { AuthEntity } from '../entities/authentication.entity';
import { AuthSessionEntity } from '../entities/authentication-session.entity';
export declare class AuthenticationSessionService extends SDKAuthenticationSessionService {
    protected readonly repository: Repository<AuthSessionEntity>;
    constructor(repository: Repository<AuthSessionEntity>);
}
export declare class AuthService extends SDKAuthenticationService<AuthEntity> {
    repo: Repository<AuthEntity>;
    tokenService: SDKTokenService;
    authenticationSessionService: AuthenticationSessionService;
    tokenSessionService: SDKTokenSessionService;
    constructor(repo: Repository<AuthEntity>, tokenService: SDKTokenService, authenticationSessionService: AuthenticationSessionService, tokenSessionService: SDKTokenSessionService);
    getWhere(where: Partial<AuthEntity> | Partial<AuthEntity>[]): Promise<AuthEntity[]>;
    register(body: SDKRegisterDTO): Promise<AuthEntity>;
    generateToken(auth: AuthEntity): Promise<{
        token: string;
    }>;
    login(body: SDKLoginDTO): Promise<AuthEntity>;
}
