"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProviderUsersService = void 0;
const common_1 = require("@nestjs/common");
const users_service_1 = require("./users.service");
const authentication_enum_1 = require("../enums/authentication.enum");
const utility_service_1 = require("../../../services/utility.service");
const typeorm_1 = require("typeorm");
let ProviderUsersService = class ProviderUsersService extends users_service_1.UsersService {
    constructor() {
        super(...arguments);
        this.type = authentication_enum_1.EAuthType.provider;
    }
    async getOrCreateWallet(authID, config) {
        if (!authID)
            utility_service_1.UtilityClass.throwError({ message: 'User id is missing' });
        const user = await this.repo.findOne({
            where: { auth: { type: authentication_enum_1.EAuthType.public, id: authID } },
            relations: { auth: true },
            select: { id: true, walletId: true },
        });
        if (!user)
            utility_service_1.UtilityClass.throwError({ message: 'User could not be found' });
        else if (!user.walletId)
            return await this.walletService._create({
                name: utility_service_1.UtilityClass.strConcatenator(user.auth.firstname, user.auth.lastname),
                active: true,
                allowOverdraft: false,
                userID: user.id,
                type: authentication_enum_1.EAuthType.public,
            }, { entityManager: config?.entityManager });
        return this.walletService.getById(user.walletId);
    }
    async createMissingWallets() {
        const users = await this.repo.find({
            where: { walletId: (0, typeorm_1.IsNull)() },
            select: { id: true, auth: { firstname: true, lastname: true } },
            relations: { auth: true },
        });
        await this.repo.manager.transaction(async (manager) => {
            await Promise.all(users.map((user) => this.walletService
                ._create({
                name: utility_service_1.UtilityClass.strConcatenator(user.auth.firstname, user.auth.lastname),
                active: true,
                allowOverdraft: false,
                userID: user.id,
                type: authentication_enum_1.EAuthType.public,
            }, { entityManager: manager, returnItem: true })
                .then((wallet) => this._updateByID(user.id, { walletId: wallet.id }, {
                entityManager: manager,
            }))));
        });
    }
};
exports.ProviderUsersService = ProviderUsersService;
ProviderUsersService.path = `user_${authentication_enum_1.EAuthType.provider}`;
exports.ProviderUsersService = ProviderUsersService = __decorate([
    (0, common_1.Injectable)()
], ProviderUsersService);
//# sourceMappingURL=provider-users.service.js.map