import { FindOptionsWhere, Repository } from 'typeorm';
import { BaseService } from 'src/services/base.service';
import { AuthEntity } from '../entities/authentication.entity';
import { UserDetailEntity, UserView } from '../entities/user-detail.entity';
import { AuthService } from './authentication.service';
import { LoginDto, CreateUserDTO, UserSearchQueryDTO } from '../dtos/authentication.dto';
import { EAuthType } from '../enums/authentication.enum';
import { IAuthParam, SDKLogoutDTO, SDKSystemLogoutDTO, SDKWalletService } from '@serene-dev/la-nest-library';
import { ToggleActiveDTO } from 'src/dtos/base.dto';
export declare abstract class UsersService extends BaseService<UserDetailEntity, UserSearchQueryDTO> {
    readonly repo: Repository<UserDetailEntity>;
    readonly repoView: Repository<UserView>;
    protected authService: AuthService;
    walletService: SDKWalletService;
    static path: string;
    type: EAuthType;
    skipCreator: boolean;
    createConfig: {
        pre?: (req: CreateUserDTO) => Promise<CreateUserDTO>;
        post?: (res: UserDetailEntity) => Promise<UserDetailEntity>;
    };
    constructor(repo: Repository<UserDetailEntity>, repoView: Repository<UserView>, authService: AuthService, walletService: SDKWalletService);
    searchV2: ({ name, firstname, partnerName, lastname, email, ...query }: UserSearchQueryDTO, auth: IAuthParam) => Promise<import("@serene-dev/la-nest-library").ISearchResponse<UserView>>;
    loginFunc: (req: LoginDto, res: AuthEntity) => Promise<any>;
    login(body: LoginDto): Promise<UserDetailEntity>;
    getSingle(where: FindOptionsWhere<UserDetailEntity>, auth?: IAuthParam): Promise<UserDetailEntity>;
    getById(id: string): Promise<UserDetailEntity>;
    getByAuthId(id: string): Promise<UserDetailEntity>;
    createUser(body: CreateUserDTO): Promise<UserDetailEntity>;
    toggleStatus(id: string, data: ToggleActiveDTO): Promise<AuthEntity>;
    forceLogout(data: SDKSystemLogoutDTO): Promise<boolean>;
    logout(data: SDKLogoutDTO): Promise<boolean>;
}
