"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsersService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
const base_service_1 = require("../../../services/base.service");
const base_enum_1 = require("../../../enums/base.enum");
const user_detail_entity_1 = require("../entities/user-detail.entity");
const authentication_service_1 = require("./authentication.service");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const typeorm_2 = require("@nestjs/typeorm");
const utility_service_1 = require("../../../services/utility.service");
let UsersService = class UsersService extends base_service_1.BaseService {
    constructor(repo, repoView, authService, walletService) {
        super(repo, base_enum_1.ETableName.userDetail);
        this.repo = repo;
        this.repoView = repoView;
        this.authService = authService;
        this.walletService = walletService;
        this.skipCreator = true;
        this.createConfig = {};
        this.searchV2 = ({ name, firstname, partnerName, lastname, email, ...query }, auth) => {
            auth;
            return utility_service_1.UtilityClass.searchView(this.repoView, query, {
                baseWhere: {
                    email: utility_service_1.UtilityClass.likeFormatter(email),
                    firstname: utility_service_1.UtilityClass.likeFormatter(firstname),
                    lastname: utility_service_1.UtilityClass.likeFormatter(lastname),
                    name: utility_service_1.UtilityClass.likeFormatter(name),
                    partnerName: utility_service_1.UtilityClass.likeFormatter(partnerName),
                    type: this.type,
                },
            });
        };
        this.loginFunc = (req, res) => {
            return Promise.resolve(res);
        };
    }
    async login(body) {
        body.type = this.type;
        const auth = await this.loginFunc(body, await this.authService.login(body));
        const res = await this.getByAuthId(auth.id);
        res.auth = auth;
        delete res.auth.password;
        return res;
    }
    async getSingle(where, auth) {
        return this.repo.findOne({
            where,
            relations: { auth: true, wallet: true },
        });
    }
    async getById(id) {
        return this.getSingle({
            id,
            auth: { type: this.type },
        });
    }
    async getByAuthId(id) {
        return this.getSingle({
            auth: { id, type: this.type },
        });
    }
    async createUser(body) {
        body.type = this.type;
        const authDetail = await this.authService.register(this.createConfig.pre ? await this.createConfig.pre(body) : body);
        const detail = Object.assign(new user_detail_entity_1.UserDetailEntity(), body);
        detail.manager = !(await this.repo.findOne({
            where: { manager: true, auth: { type: body.type } },
            select: { id: true },
        }));
        detail.auth = authDetail;
        const res = await this.getById((await this.repo.save(detail)).id);
        await this.walletService._create({
            allowOverdraft: false,
            overdraftLimit: 0,
            userID: res.id,
            name: utility_service_1.UtilityClass.strConcatenator(authDetail.firstname, authDetail.lastname, ' '),
            type: this.type,
        });
        delete res.auth.password;
        return this.createConfig.post ? this.createConfig.post(res) : res;
    }
    async toggleStatus(id, data) {
        const detail = await this.getById(id);
        if (!detail)
            utility_service_1.UtilityClass.throwError({ message: `ID is invalid` });
        return await this.authService.toggleStatus(detail.auth.id, data);
    }
    async forceLogout(data) {
        return this.authService.forceLogout(data);
    }
    async logout(data) {
        return this.authService.logout(data);
    }
};
exports.UsersService = UsersService;
UsersService.path = `user`;
exports.UsersService = UsersService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(user_detail_entity_1.UserDetailEntity)),
    __param(1, (0, typeorm_2.InjectRepository)(user_detail_entity_1.UserView)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        typeorm_1.Repository,
        authentication_service_1.AuthService,
        la_nest_library_1.SDKWalletService])
], UsersService);
//# sourceMappingURL=users.service.js.map