import { FindOptionsWhere, Repository } from 'typeorm';
import { BaseService } from '../../services/base.service';
import { ChannelPricingEntity } from './channel-pricing.entity';
import { CreateChannelPricingDTO, SearchChannelPricingDTO } from './channel-pricing.dto';
import { IAuthParam } from '../authentication/interfaces/authentication.interface';
import { ISearchResponse } from '@serene-dev/la-nest-library';
export declare class ChannelPricingService extends BaseService<ChannelPricingEntity, SearchChannelPricingDTO> {
    repo: Repository<ChannelPricingEntity>;
    static path: string;
    constructor(repo: Repository<ChannelPricingEntity>);
    getSingle(where: FindOptionsWhere<ChannelPricingEntity>, auth?: IAuthParam): Promise<ChannelPricingEntity>;
    search({ channelName, providerName, providerId, amount, amountFrom, durationDays, isRecurrent, amountTo, sortField, sortDirection, ...query }: SearchChannelPricingDTO, auth?: IAuthParam): Promise<ISearchResponse<ChannelPricingEntity>>;
    protected _postCreateFunction(requestData: CreateChannelPricingDTO, savedData: ChannelPricingEntity): Promise<void>;
}
