"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChannelPricingService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const base_service_1 = require("../../services/base.service");
const channel_pricing_entity_1 = require("./channel-pricing.entity");
const utility_service_1 = require("../../services/utility.service");
const base_enum_1 = require("../../enums/base.enum");
let ChannelPricingService = class ChannelPricingService extends base_service_1.BaseService {
    constructor(repo) {
        super(repo, base_enum_1.ETableName.channel_pricings);
        this.repo = repo;
    }
    async getSingle(where, auth) {
        const r = await this.repo.findOne({
            where,
            relations: {
                pricing: true,
                channel: { provider: true },
            },
        });
        return r;
    }
    search({ channelName, providerName, providerId, amount, amountFrom, durationDays, isRecurrent, amountTo, sortField, sortDirection, ...query }, auth) {
        return utility_service_1.UtilityClass.searchView(this.repo, query, {
            baseWhere: {
                channel: {
                    name: utility_service_1.UtilityClass.likeFormatter(channelName),
                    providerId,
                    provider: { name: utility_service_1.UtilityClass.likeFormatter(providerName) },
                },
                pricing: {
                    durationDays,
                    isRecurrent,
                    amount: utility_service_1.UtilityClass.computeRangeQuery(amount, amountFrom, amountTo),
                },
            },
            baseOrder: {
                pricing: sortField ? { [sortField]: sortDirection } : null,
            },
            baseRelations: {
                pricing: true,
                channel: { provider: true },
            },
            baseSelect: {},
        });
    }
    async _postCreateFunction(requestData, savedData) {
        await this.repo.update({
            id: (0, typeorm_2.Not)(savedData.id),
            pricingId: requestData.pricingId,
            channelId: requestData.channelId,
        }, { active: false });
    }
};
exports.ChannelPricingService = ChannelPricingService;
ChannelPricingService.path = `channel_pricings`;
exports.ChannelPricingService = ChannelPricingService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(channel_pricing_entity_1.ChannelPricingEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], ChannelPricingService);
//# sourceMappingURL=channel-pricing.service.js.map