import { BaseCRUDController } from '@serene-dev/la-nest-library/dist/libs/la-library/src/controllers/base.controller';
import { IDDto } from '@serene-dev/la-nest-library';
import { ChannelEntity } from './channel.entity';
import { CreateChannelDTO, SearchChannelDTO, UpdateChannelDTO } from './channel.dto';
import { ChannelService } from './channel.service';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
export declare class ChannelController extends BaseCRUDController<ChannelEntity, SearchChannelDTO> {
    protected service: ChannelService;
    constructor(service: ChannelService);
    search(query: SearchChannelDTO, auth?: IAuthParam): Promise<string | import("@serene-dev/la-nest-library").ISearchResponse<ChannelEntity>>;
    create(body: CreateChannelDTO, auth: IAuthParam): string | Promise<ChannelEntity>;
    updateByID(param: IDDto, body: UpdateChannelDTO, auth: IAuthParam): string | Promise<ChannelEntity>;
}
