"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChannelController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const base_controller_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/controllers/base.controller");
const search_dto_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/dtos/search.dto");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const channel_dto_1 = require("./channel.dto");
const channel_service_1 = require("./channel.service");
const jwt_auth_guard_1 = require("../../modules/authentication/guards/jwt-auth.guard");
const authentication_enum_1 = require("../../modules/authentication/enums/authentication.enum");
let ChannelController = class ChannelController extends base_controller_1.BaseCRUDController {
    constructor(service) {
        super(service);
        this.service = service;
    }
    async search(query, auth) {
        return super.search(query, auth);
    }
    create(body, auth) {
        return super.create(body, auth);
    }
    updateByID(param, body, auth) {
        return super.updateByID(param, body, auth);
    }
};
exports.ChannelController = ChannelController;
__decorate([
    (0, common_1.Get)('search'),
    (0, swagger_1.ApiResponse)({ type: search_dto_1.SearchResponseDto }),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [channel_dto_1.SearchChannelDTO, Object]),
    __metadata("design:returntype", Promise)
], ChannelController.prototype, "search", null);
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [channel_dto_1.CreateChannelDTO, Object]),
    __metadata("design:returntype", void 0)
], ChannelController.prototype, "create", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, jwt_auth_guard_1.Role)(authentication_enum_1.EAuthType.admin),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.IDDto,
        channel_dto_1.UpdateChannelDTO, Object]),
    __metadata("design:returntype", void 0)
], ChannelController.prototype, "updateByID", null);
exports.ChannelController = ChannelController = __decorate([
    (0, swagger_1.ApiTags)(channel_service_1.ChannelService.tag),
    (0, common_1.Controller)(channel_service_1.ChannelService.path),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [channel_service_1.ChannelService])
], ChannelController);
//# sourceMappingURL=channel.controller.js.map