import { FindOptionsWhere, Repository } from 'typeorm';
import { BaseService } from '../../services/base.service';
import { ChannelEntity } from './channel.entity';
import { SearchChannelDTO } from './channel.dto';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
import { ISearchResponse } from '@serene-dev/la-nest-library';
import { SubscriptionService } from '../subscription/subscription.service';
export declare class ChannelService extends BaseService<ChannelEntity, SearchChannelDTO> {
    repo: Repository<ChannelEntity>;
    protected subscriptionService: SubscriptionService;
    static path: string;
    constructor(repo: Repository<ChannelEntity>, subscriptionService: SubscriptionService);
    getSingle(where: FindOptionsWhere<ChannelEntity>, auth?: IAuthParam): Promise<ChannelEntity>;
    setAsPrimary(id: string): Promise<void>;
    protected _postCreateFunction(requestData: Partial<ChannelEntity>, savedData: ChannelEntity): Promise<void>;
    protected _postUpdateFunction(id: string, data: Partial<ChannelEntity>): Promise<void>;
    search({ name, description, providerName, hasAccess, ...query }: SearchChannelDTO, auth?: IAuthParam): Promise<ISearchResponse<ChannelEntity>>;
}
