"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChannelService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const base_service_1 = require("../../services/base.service");
const channel_entity_1 = require("./channel.entity");
const utility_service_1 = require("../../services/utility.service");
const base_enum_1 = require("../../enums/base.enum");
const subscription_service_1 = require("../subscription/subscription.service");
const subscription_enum_1 = require("../subscription/subscription.enum");
let ChannelService = class ChannelService extends base_service_1.BaseService {
    constructor(repo, subscriptionService) {
        super(repo, base_enum_1.ETableName.channels);
        this.repo = repo;
        this.subscriptionService = subscriptionService;
    }
    async getSingle(where, auth) {
        const r = await this.repo.findOne({
            where,
            relations: { provider: true },
        });
        if (r && auth?.id) {
            const access = await this.subscriptionService.userAccessStatus(auth.id, {
                channelId: r.id,
            });
            if (access) {
                r['hasAccess'] =
                    access.status == subscription_enum_1.EVerificationStatus.verified && access.active;
                r['access'] = access;
            }
        }
        return r;
    }
    async setAsPrimary(id) {
        const channel = await this.repo.findOne({
            where: { id: id },
            select: { id: true, providerId: true },
        });
        if (!channel) {
            utility_service_1.UtilityClass.throwError({ message: `Channel does not exist` });
        }
        await this.repo.update({ providerId: channel.providerId }, { isPrimary: false });
        await this.repo.update({ id }, { isPrimary: true });
    }
    async _postCreateFunction(requestData, savedData) {
        if (requestData.isPrimary)
            await this.setAsPrimary(savedData.id);
    }
    async _postUpdateFunction(id, data) {
        if (data.isPrimary)
            await this.setAsPrimary(id);
    }
    search({ name, description, providerName, hasAccess, ...query }, auth) {
        return utility_service_1.UtilityClass.search(this.repo, query, {
            baseWhere: {
                name: utility_service_1.UtilityClass.likeFormatter(name),
                description: utility_service_1.UtilityClass.likeFormatter(description),
                provider: { name: utility_service_1.UtilityClass.likeFormatter(providerName) },
                channelPricings: hasAccess
                    ? {
                        subscriptions: { active: true, userAuthId: auth?.id },
                    }
                    : null,
            },
            baseRelations: {
                provider: true,
                channelPricings: { subscriptions: true },
            },
        });
    }
};
exports.ChannelService = ChannelService;
ChannelService.path = `channels`;
exports.ChannelService = ChannelService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(channel_entity_1.ChannelEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        subscription_service_1.SubscriptionService])
], ChannelService);
//# sourceMappingURL=channel.service.js.map