import { FindOptionsWhere, Repository } from 'typeorm';
import { BaseService } from '../../services/base.service';
import { ContentCategoryEntity } from './content-category.entity';
import { SearchContentCategoryDTO } from './content-category.dto';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
import { ISearchResponse } from '@serene-dev/la-nest-library';
export declare class ContentCategoryService extends BaseService<ContentCategoryEntity, SearchContentCategoryDTO> {
    repo: Repository<ContentCategoryEntity>;
    static path: string;
    constructor(repo: Repository<ContentCategoryEntity>);
    getSingle(where: FindOptionsWhere<ContentCategoryEntity>, auth?: IAuthParam): Promise<ContentCategoryEntity>;
    search({ name, description, ...query }: SearchContentCategoryDTO, auth?: IAuthParam): Promise<ISearchResponse<ContentCategoryEntity>>;
}
