"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentCategoryService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const base_service_1 = require("../../services/base.service");
const content_category_entity_1 = require("./content-category.entity");
const utility_service_1 = require("../../services/utility.service");
const base_enum_1 = require("../../enums/base.enum");
let ContentCategoryService = class ContentCategoryService extends base_service_1.BaseService {
    constructor(repo) {
        super(repo, base_enum_1.ETableName.content_categories);
        this.repo = repo;
    }
    async getSingle(where, auth) {
        const r = await this.repo.findOne({
            where,
        });
        return r;
    }
    search({ name, description, ...query }, auth) {
        return utility_service_1.UtilityClass.searchView(this.repo, query, {
            baseWhere: {
                name: utility_service_1.UtilityClass.likeFormatter(name),
                description: utility_service_1.UtilityClass.likeFormatter(description),
            },
        });
    }
};
exports.ContentCategoryService = ContentCategoryService;
ContentCategoryService.path = `content_categories`;
exports.ContentCategoryService = ContentCategoryService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(content_category_entity_1.ContentCategoryEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], ContentCategoryService);
//# sourceMappingURL=content-category.service.js.map