"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentFavouriteController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const content_favourite_dto_1 = require("./content-favourite.dto");
const content_favourite_service_1 = require("./content-favourite.service");
const utility_service_1 = require("../../services/utility.service");
const base_controller_1 = require("../../controllers/base.controller");
const jwt_auth_guard_1 = require("../authentication/guards/jwt-auth.guard");
const authentication_enum_1 = require("../authentication/enums/authentication.enum");
let ContentFavouriteController = class ContentFavouriteController extends base_controller_1.BaseController {
    constructor(service) {
        super(service);
        this.service = service;
    }
    async search(query, auth) {
        return super.search(query, auth);
    }
    async toggle(body, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.toggleFavourite(body, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.ContentFavouriteController = ContentFavouriteController;
__decorate([
    (0, common_1.Get)('search'),
    (0, jwt_auth_guard_1.Role)(authentication_enum_1.EAuthType.admin),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [content_favourite_dto_1.SearchContentFavouriteDTO, Object]),
    __metadata("design:returntype", Promise)
], ContentFavouriteController.prototype, "search", null);
__decorate([
    (0, common_1.Post)('toggle'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [content_favourite_dto_1.ToggleFavouriteDto, Object]),
    __metadata("design:returntype", Promise)
], ContentFavouriteController.prototype, "toggle", null);
exports.ContentFavouriteController = ContentFavouriteController = __decorate([
    (0, swagger_1.ApiTags)(content_favourite_service_1.ContentFavouriteService.tag),
    (0, common_1.Controller)(content_favourite_service_1.ContentFavouriteService.path),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [content_favourite_service_1.ContentFavouriteService])
], ContentFavouriteController);
//# sourceMappingURL=content-favourite.controller.js.map