import { FindOptionsWhere, Repository } from 'typeorm';
import { BaseService } from '../../services/base.service';
import { ContentFavouriteEntity } from './content-favourite.entity';
import { SearchContentFavouriteDTO, ToggleFavouriteDto } from './content-favourite.dto';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
import { ISearchResponse } from '@serene-dev/la-nest-library';
export declare class ContentFavouriteService extends BaseService<ContentFavouriteEntity, SearchContentFavouriteDTO> {
    repo: Repository<ContentFavouriteEntity>;
    static path: string;
    constructor(repo: Repository<ContentFavouriteEntity>);
    getSingle(where: FindOptionsWhere<ContentFavouriteEntity>, auth?: IAuthParam): Promise<ContentFavouriteEntity>;
    toggleFavourite(data: ToggleFavouriteDto, auth: IAuthParam): Promise<boolean>;
    search(query: SearchContentFavouriteDTO, auth: IAuthParam): Promise<ISearchResponse<ContentFavouriteEntity>>;
}
