import { IDDto, ISearchResponse } from '@serene-dev/la-nest-library';
import { BaseCRUDController } from '@serene-dev/la-nest-library/dist/libs/la-library/src/controllers/base.controller';
import { IAuthParam } from '../authentication/interfaces/authentication.interface';
import { ContentGroupEntity } from './content-group.entity';
import { ContentGroupService } from './content-group.service';
import { AddContentToGroupDTO, CreateContentGroupDTO, SearchContentGroupDTO, UpdateContentGroupDTO } from './content-group.dto';
export declare class ContentGroupController extends BaseCRUDController<ContentGroupEntity, SearchContentGroupDTO> {
    protected service: ContentGroupService;
    constructor(service: ContentGroupService);
    search(query: SearchContentGroupDTO, auth?: IAuthParam): Promise<string | ISearchResponse<ContentGroupEntity>>;
    types(): string | import("@serene-dev/la-nest-library").ValueLabelDto<any>[];
    create(body: CreateContentGroupDTO, auth: IAuthParam): string | Promise<ContentGroupEntity>;
    updateByID(param: IDDto, body: UpdateContentGroupDTO, auth: IAuthParam): string | Promise<ContentGroupEntity>;
    addContentsToGroup(param: IDDto, body: AddContentToGroupDTO, auth: IAuthParam): Promise<string | void>;
    removeContentFromGroup(id: string, contentId: string, auth: IAuthParam): Promise<string | void>;
}
