"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentGroupController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const base_controller_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/controllers/base.controller");
const search_dto_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/dtos/search.dto");
const authentication_enum_1 = require("../authentication/enums/authentication.enum");
const jwt_auth_guard_1 = require("../authentication/guards/jwt-auth.guard");
const utility_service_1 = require("../../services/utility.service");
const content_enum_1 = require("../../enums/content.enum");
const content_group_service_1 = require("./content-group.service");
const content_group_dto_1 = require("./content-group.dto");
let ContentGroupController = class ContentGroupController extends base_controller_1.BaseCRUDController {
    constructor(service) {
        super(service);
        this.service = service;
    }
    async search(query, auth) {
        return super.search(query, auth);
    }
    types() {
        return utility_service_1.UtilityClass.returnEnum(content_enum_1.EContentGroupType);
    }
    create(body, auth) {
        utility_service_1.UtilityClass.patchSearchWithOrg(body, auth);
        return super.create(body, auth);
    }
    updateByID(param, body, auth) {
        return super.updateByID(param, body, auth);
    }
    async addContentsToGroup(param, body, auth) {
        try {
            const data = await this.service.addContentsToGroup(param.id, body.items, auth);
            return utility_service_1.UtilityClass.handleSuccess({ data });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async removeContentFromGroup(id, contentId, auth) {
        try {
            const data = await this.service.removeContentFromGroup(id, contentId, auth);
            return utility_service_1.UtilityClass.handleSuccess({ data });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.ContentGroupController = ContentGroupController;
__decorate([
    (0, common_1.Get)('search'),
    (0, swagger_1.ApiOperation)({ summary: 'Search content groups' }),
    (0, swagger_1.ApiResponse)({ type: search_dto_1.SearchResponseDto }),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [content_group_dto_1.SearchContentGroupDTO, Object]),
    __metadata("design:returntype", Promise)
], ContentGroupController.prototype, "search", null);
__decorate([
    (0, common_1.Get)('types'),
    (0, swagger_1.ApiOperation)({ summary: 'Get all content group types' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ContentGroupController.prototype, "types", null);
__decorate([
    (0, common_1.Post)(),
    (0, swagger_1.ApiOperation)({ summary: 'Create a new content group' }),
    (0, jwt_auth_guard_1.Role)([authentication_enum_1.EAuthType.admin, authentication_enum_1.EAuthType.provider]),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [content_group_dto_1.CreateContentGroupDTO, Object]),
    __metadata("design:returntype", void 0)
], ContentGroupController.prototype, "create", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, swagger_1.ApiOperation)({ summary: 'Update a content group by ID' }),
    (0, jwt_auth_guard_1.Role)([authentication_enum_1.EAuthType.admin, authentication_enum_1.EAuthType.provider]),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.IDDto,
        content_group_dto_1.UpdateContentGroupDTO, Object]),
    __metadata("design:returntype", void 0)
], ContentGroupController.prototype, "updateByID", null);
__decorate([
    (0, common_1.Post)(':id/contents'),
    (0, swagger_1.ApiOperation)({ summary: 'Add contents to a content group' }),
    (0, jwt_auth_guard_1.Role)([authentication_enum_1.EAuthType.admin, authentication_enum_1.EAuthType.provider]),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.IDDto,
        content_group_dto_1.AddContentToGroupDTO, Object]),
    __metadata("design:returntype", Promise)
], ContentGroupController.prototype, "addContentsToGroup", null);
__decorate([
    (0, common_1.Delete)(':id/contents/:contentId/remove'),
    (0, swagger_1.ApiOperation)({ summary: 'Remove content from a content group' }),
    (0, jwt_auth_guard_1.Role)([authentication_enum_1.EAuthType.admin, authentication_enum_1.EAuthType.provider]),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Param)('contentId')),
    __param(2, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Object]),
    __metadata("design:returntype", Promise)
], ContentGroupController.prototype, "removeContentFromGroup", null);
exports.ContentGroupController = ContentGroupController = __decorate([
    (0, swagger_1.ApiTags)(content_group_service_1.ContentGroupService.tag),
    (0, common_1.Controller)(content_group_service_1.ContentGroupService.path),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [content_group_service_1.ContentGroupService])
], ContentGroupController);
//# sourceMappingURL=content-group.controller.js.map