"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddContentToGroupDTO = exports.ContentGroupItemDTO = exports.SearchContentGroupDTO = exports.UpdateContentGroupDTO = exports.CreateContentGroupDTO = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const class_transformer_1 = require("class-transformer");
const base_entity_1 = require("../../entities/base.entity");
const content_enum_1 = require("../../enums/content.enum");
const base_dto_1 = require("../../dtos/base.dto");
class CreateContentGroupDTO extends base_dto_1.BaseDto {
}
exports.CreateContentGroupDTO = CreateContentGroupDTO;
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], CreateContentGroupDTO.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateContentGroupDTO.prototype, "orgID", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateContentGroupDTO.prototype, "description", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: content_enum_1.EContentGroupType }),
    (0, class_validator_1.IsEnum)(content_enum_1.EContentGroupType),
    __metadata("design:type", String)
], CreateContentGroupDTO.prototype, "type", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: content_enum_1.EContentStatus }),
    (0, class_validator_1.IsEnum)(content_enum_1.EContentStatus),
    __metadata("design:type", String)
], CreateContentGroupDTO.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: content_enum_1.EContentVisibility }),
    (0, class_validator_1.IsEnum)(content_enum_1.EContentVisibility),
    __metadata("design:type", String)
], CreateContentGroupDTO.prototype, "visibility", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)({ each: true }),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Array)
], CreateContentGroupDTO.prototype, "contentIds", void 0);
class UpdateContentGroupDTO extends (0, swagger_1.PartialType)(CreateContentGroupDTO) {
}
exports.UpdateContentGroupDTO = UpdateContentGroupDTO;
class SearchContentGroupDTO extends (0, swagger_1.IntersectionType)(base_entity_1.SearchQueryDto, UpdateContentGroupDTO) {
}
exports.SearchContentGroupDTO = SearchContentGroupDTO;
class ContentGroupItemDTO extends base_dto_1.BaseDto {
}
exports.ContentGroupItemDTO = ContentGroupItemDTO;
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsUUID)(),
    __metadata("design:type", String)
], ContentGroupItemDTO.prototype, "contentId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], ContentGroupItemDTO.prototype, "order", void 0);
class AddContentToGroupDTO {
}
exports.AddContentToGroupDTO = AddContentToGroupDTO;
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsArray)(),
    (0, class_transformer_1.Type)(() => ContentGroupItemDTO),
    __metadata("design:type", Array)
], AddContentToGroupDTO.prototype, "items", void 0);
//# sourceMappingURL=content-group.dto.js.map