import { Relation } from 'typeorm';
import { BaseEntity } from '../../entities/base.entity';
import { EContentGroupType, EContentStatus, EContentVisibility } from '../../enums/content.enum';
import { ContentEntity } from '../content/content.entity';
import { PosterEntity } from '../poster/poster.entity';
export declare class ContentGroupEntity extends BaseEntity {
    name: string;
    description?: string;
    type: EContentGroupType;
    status: EContentStatus;
    visibility: EContentVisibility;
    items?: Relation<ContentGroupItemEntity[]>;
    posters?: Relation<PosterEntity[]>;
}
export declare class ContentGroupItemEntity extends BaseEntity {
    group?: Relation<ContentGroupEntity>;
    groupId: string;
    content?: Relation<ContentEntity>;
    contentId: string;
}
