import { Repository, FindOptionsWhere } from 'typeorm';
import { BaseService } from '../../services/base.service';
import { ContentGroupEntity } from './content-group.entity';
import { IAuthParam } from '../authentication/interfaces/authentication.interface';
import { ContentGroupItemDTO, CreateContentGroupDTO, SearchContentGroupDTO } from './content-group.dto';
import { ContentGroupItemService } from './content-group-item.service';
export declare class ContentGroupService extends BaseService<ContentGroupEntity, SearchContentGroupDTO> {
    repo: Repository<ContentGroupEntity>;
    private contentGroupItemService;
    static path: string;
    constructor(repo: Repository<ContentGroupEntity>, contentGroupItemService: ContentGroupItemService);
    getSingle(where: FindOptionsWhere<ContentGroupEntity>, auth?: IAuthParam): Promise<ContentGroupEntity>;
    search({ name, description, contentIds, ...query }: SearchContentGroupDTO, auth?: IAuthParam): Promise<import("@serene-dev/la-nest-library").ISearchResponse<ContentGroupEntity>>;
    addContentsToGroup(groupId: string, items: ContentGroupItemDTO[], auth?: IAuthParam): Promise<void>;
    removeContentFromGroup(groupId: string, contentId: string, auth: IAuthParam): Promise<void>;
    protected _postCreateFunction(requestData: CreateContentGroupDTO, savedData: ContentGroupEntity): Promise<void>;
}
