"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentGroupService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const base_service_1 = require("../../services/base.service");
const base_enum_1 = require("../../enums/base.enum");
const content_group_entity_1 = require("./content-group.entity");
const utility_service_1 = require("../../services/utility.service");
const content_group_item_service_1 = require("./content-group-item.service");
let ContentGroupService = class ContentGroupService extends base_service_1.BaseService {
    constructor(repo, contentGroupItemService) {
        super(repo, base_enum_1.ETableName.content_groups);
        this.repo = repo;
        this.contentGroupItemService = contentGroupItemService;
    }
    async getSingle(where, auth) {
        utility_service_1.UtilityClass.patchSearchWithOrg(where, auth);
        const r = await this.repo.findOne({
            where,
            relations: {
                items: {
                    content: true,
                },
            },
            select: { items: { content: { name: true } } },
        });
        return r;
    }
    async search({ name, description, contentIds, ...query }, auth) {
        utility_service_1.UtilityClass.patchSearchWithOrg(query, auth);
        return utility_service_1.UtilityClass.search(this.repo, query, {
            baseWhere: {
                name: utility_service_1.UtilityClass.likeFormatter(name),
                description: utility_service_1.UtilityClass.likeFormatter(description),
                items: { contentId: utility_service_1.UtilityClass.computeArrayFieldQuery(contentIds) },
            },
            baseRelations: {
                items: {
                    content: true,
                },
            },
            baseSelect: { items: { content: { name: true } } },
        });
    }
    async addContentsToGroup(groupId, items, auth) {
        await this.repo.manager.transaction(async (manager) => {
            for (const item of items) {
                await this.contentGroupItemService._create({
                    ...item,
                    groupId,
                    creatorId: item.creatorId || auth?.id,
                }, { entityManager: manager, auth });
            }
        });
    }
    async removeContentFromGroup(groupId, contentId, auth) {
        await this.contentGroupItemService.repo.delete({
            contentId,
            group: utility_service_1.UtilityClass.patchSearchWithOrg({ id: groupId }, auth),
        });
    }
    async _postCreateFunction(requestData, savedData) {
        if (requestData.contentIds && requestData.contentIds.length > 0) {
            const items = requestData.contentIds.map((contentId, index) => ({
                contentId,
                order: index,
                creatorId: savedData.creatorId,
            }));
            await this.addContentsToGroup(savedData.id, items);
        }
    }
};
exports.ContentGroupService = ContentGroupService;
ContentGroupService.path = `content_groups`;
exports.ContentGroupService = ContentGroupService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(content_group_entity_1.ContentGroupEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        content_group_item_service_1.ContentGroupItemService])
], ContentGroupService);
//# sourceMappingURL=content-group.service.js.map