import { BaseCRUDController } from '@serene-dev/la-nest-library/dist/libs/la-library/src/controllers/base.controller';
import { IDDto } from '@serene-dev/la-nest-library';
import { ContentScheduleService } from './content-schedule.service';
import { ContentScheduleEntity } from './content-schedule.entity';
import { SearchContentScheduleDTO, CreateContentScheduleDTO, UpdateContentScheduleDTO, SearchContentCurrentScheduleDTO } from './content-schedule.dto';
import { IAuthParam } from '../authentication/interfaces/authentication.interface';
import { SearchQueryDto } from '../../entities/base.entity';
export declare class ContentScheduleController extends BaseCRUDController<ContentScheduleEntity, SearchContentScheduleDTO> {
    protected service: ContentScheduleService;
    constructor(service: ContentScheduleService);
    search(query: SearchContentScheduleDTO, auth?: IAuthParam): Promise<string | import("@serene-dev/la-nest-library").ISearchResponse<ContentScheduleEntity>>;
    searchCurrent(query: SearchContentCurrentScheduleDTO, auth?: IAuthParam): Promise<string | import("@serene-dev/la-nest-library").ISearchResponse<ContentScheduleEntity>>;
    searchFavourites(query: SearchQueryDto, auth: IAuthParam): Promise<string | import("@serene-dev/la-nest-library").ISearchResponse<ContentScheduleEntity>>;
    create(body: CreateContentScheduleDTO, auth: IAuthParam): string | Promise<ContentScheduleEntity>;
    updateByID(param: IDDto, body: UpdateContentScheduleDTO, auth: IAuthParam): string | Promise<ContentScheduleEntity>;
}
