"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchContentCurrentScheduleDTO = exports.SearchContentScheduleDTO = exports.UpdateContentScheduleDTO = exports.CreateContentScheduleDTO = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const base_entity_1 = require("../../entities/base.entity");
const video_enum_1 = require("../video/video.enum");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
class CreateContentScheduleDTO {
}
exports.CreateContentScheduleDTO = CreateContentScheduleDTO;
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_transformer_1.Type)(() => Number),
    __metadata("design:type", Number)
], CreateContentScheduleDTO.prototype, "releaseDateTime", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], CreateContentScheduleDTO.prototype, "releaseDateTimeEnd", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsUUID)(),
    __metadata("design:type", String)
], CreateContentScheduleDTO.prototype, "contentId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsBoolean)(),
    (0, la_nest_library_1.ToBoolean)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Boolean)
], CreateContentScheduleDTO.prototype, "isLive", void 0);
class UpdateContentScheduleDTO extends (0, swagger_1.PartialType)(CreateContentScheduleDTO) {
}
exports.UpdateContentScheduleDTO = UpdateContentScheduleDTO;
class SearchContentScheduleDTO extends (0, swagger_1.IntersectionType)(base_entity_1.SearchQueryDto, UpdateContentScheduleDTO) {
}
exports.SearchContentScheduleDTO = SearchContentScheduleDTO;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], SearchContentScheduleDTO.prototype, "releaseDateTimeFrom", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], SearchContentScheduleDTO.prototype, "releaseDateTimeTo", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], SearchContentScheduleDTO.prototype, "releaseDateTimeEndFrom", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], SearchContentScheduleDTO.prototype, "releaseDateTimeEndTo", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchContentScheduleDTO.prototype, "providerId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchContentScheduleDTO.prototype, "channelId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchContentScheduleDTO.prototype, "categoryId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchContentScheduleDTO.prototype, "providerName", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchContentScheduleDTO.prototype, "contentName", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchContentScheduleDTO.prototype, "channelName", void 0);
class SearchContentCurrentScheduleDTO extends (0, swagger_1.OmitType)(SearchContentScheduleDTO, [
    'releaseDateTimeFrom',
    'releaseDateTimeTo',
    'releaseDateTimeEndFrom',
    'releaseDateTimeEndTo',
    'releaseDateTime',
    'releaseDateTimeEnd',
]) {
}
exports.SearchContentCurrentScheduleDTO = SearchContentCurrentScheduleDTO;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsBoolean)(),
    (0, la_nest_library_1.ToBoolean)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Boolean)
], SearchContentCurrentScheduleDTO.prototype, "isMainBanner", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsBoolean)(),
    (0, la_nest_library_1.ToBoolean)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Boolean)
], SearchContentCurrentScheduleDTO.prototype, "isTrending", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ enum: video_enum_1.EVideoQuality }),
    (0, class_validator_1.IsEnum)(video_enum_1.EVideoQuality),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchContentCurrentScheduleDTO.prototype, "quality", void 0);
//# sourceMappingURL=content-schedule.dto.js.map