import { Repository, FindOptionsWhere, FindOptionsSelect, FindOptionsRelations } from 'typeorm';
import { ISearchResponse, ICreateConfig } from '@serene-dev/la-nest-library';
import { BaseService } from '../../services/base.service';
import { ContentScheduleEntity } from './content-schedule.entity';
import { SearchContentScheduleDTO, CreateContentScheduleDTO, SearchContentCurrentScheduleDTO } from './content-schedule.dto';
import { IAuthParam } from '../authentication/interfaces/authentication.interface';
import { SearchQueryDto } from '../../entities/base.entity';
export declare class ContentScheduleService extends BaseService<ContentScheduleEntity, SearchContentScheduleDTO> {
    repo: Repository<ContentScheduleEntity>;
    static path: string;
    constructor(repo: Repository<ContentScheduleEntity>);
    getSingle(where: FindOptionsWhere<ContentScheduleEntity>, auth?: IAuthParam): Promise<ContentScheduleEntity>;
    protected readonly searchSelect: FindOptionsSelect<ContentScheduleEntity>;
    protected readonly searchRelations: FindOptionsRelations<ContentScheduleEntity>;
    search({ providerName, providerId, channelName, channelId, categoryId, contentName, releaseDateTime, releaseDateTimeFrom, releaseDateTimeTo, releaseDateTimeEnd, releaseDateTimeEndFrom, releaseDateTimeEndTo, ...query }: SearchContentScheduleDTO, auth?: IAuthParam): Promise<ISearchResponse<ContentScheduleEntity>>;
    searchCurrent({ providerName, providerId, channelName, channelId, categoryId, contentName, isMainBanner, isTrending, ...query }: SearchContentCurrentScheduleDTO, auth?: IAuthParam): Promise<ISearchResponse<ContentScheduleEntity>>;
    searchFavourites(query: SearchQueryDto<ContentScheduleEntity>, auth: IAuthParam): Promise<ISearchResponse<ContentScheduleEntity>>;
    _create(data: CreateContentScheduleDTO, config?: ICreateConfig): Promise<ContentScheduleEntity>;
    protected cleanupOrphanedSchedules(): Promise<void>;
}
