"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentScheduleService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const base_service_1 = require("../../services/base.service");
const utility_service_1 = require("../../services/utility.service");
const content_schedule_entity_1 = require("./content-schedule.entity");
const base_enum_1 = require("../../enums/base.enum");
const schedule_1 = require("@nestjs/schedule");
const content_util_1 = require("../content/content.util");
let ContentScheduleService = class ContentScheduleService extends base_service_1.BaseService {
    constructor(repo) {
        super(repo, base_enum_1.ETableName.content_schedules);
        this.repo = repo;
        this.searchSelect = {
            content: {
                id: true,
                name: true,
                channel: { id: true, name: true },
                category: { id: true, name: true },
            },
        };
        this.searchRelations = {
            content: { channel: true, category: true },
        };
        setTimeout(() => {
            this.cleanupOrphanedSchedules();
        }, 3000);
    }
    async getSingle(where, auth) {
        const r = await this.repo.findOne({
            where,
            relations: {
                content: true,
            },
        });
        return r;
    }
    search({ providerName, providerId, channelName, channelId, categoryId, contentName, releaseDateTime, releaseDateTimeFrom, releaseDateTimeTo, releaseDateTimeEnd, releaseDateTimeEndFrom, releaseDateTimeEndTo, ...query }, auth) {
        return utility_service_1.UtilityClass.search(this.repo, query, {
            baseWhere: {
                content: {
                    channelId,
                    categoryId,
                    channel: {
                        name: utility_service_1.UtilityClass.likeFormatter(channelName),
                        providerId,
                        provider: { name: utility_service_1.UtilityClass.likeFormatter(providerName) },
                    },
                    name: utility_service_1.UtilityClass.likeFormatter(contentName),
                    ...content_util_1.ContentUtil.publicFilter(auth),
                },
                releaseDateTime: utility_service_1.UtilityClass.computeRangeQuery(releaseDateTime, releaseDateTimeFrom, releaseDateTimeTo),
                releaseDateTimeEnd: utility_service_1.UtilityClass.computeRangeQuery(releaseDateTimeEnd, releaseDateTimeEndFrom, releaseDateTimeEndTo),
            },
            baseSelect: this.searchSelect,
            baseRelations: this.searchRelations,
        });
    }
    searchCurrent({ providerName, providerId, channelName, channelId, categoryId, contentName, isMainBanner, isTrending, ...query }, auth) {
        const today = Date.now();
        return utility_service_1.UtilityClass.search(this.repo, query, {
            baseWhere: {
                mainBanner: isMainBanner ? (0, typeorm_2.Not)((0, typeorm_2.IsNull)()) : null,
                trending: isTrending ? (0, typeorm_2.Not)((0, typeorm_2.IsNull)()) : null,
                content: {
                    channelId,
                    categoryId,
                    channel: {
                        name: utility_service_1.UtilityClass.likeFormatter(channelName),
                        providerId: providerId,
                        provider: { name: utility_service_1.UtilityClass.likeFormatter(providerName) },
                    },
                    name: utility_service_1.UtilityClass.likeFormatter(contentName),
                    ...content_util_1.ContentUtil.publicFilter(auth),
                },
                releaseDateTime: (0, typeorm_2.LessThanOrEqual)(today),
                releaseDateTimeEnd: (0, typeorm_2.Or)((0, typeorm_2.IsNull)(), (0, typeorm_2.MoreThanOrEqual)(today)),
            },
            baseSelect: this.searchSelect,
            baseRelations: this.searchRelations,
        });
    }
    searchFavourites(query, auth) {
        const today = Date.now();
        return utility_service_1.UtilityClass.search(this.repo, query, {
            baseWhere: {
                favourites: { creatorId: auth.id },
                releaseDateTime: (0, typeorm_2.LessThanOrEqual)(today),
                releaseDateTimeEnd: (0, typeorm_2.Or)((0, typeorm_2.IsNull)(), (0, typeorm_2.MoreThanOrEqual)(today)),
                content: content_util_1.ContentUtil.publicFilter(auth),
            },
            baseSelect: this.searchSelect,
            baseRelations: this.searchRelations,
        });
    }
    _create(data, config) {
        return super._create(data, config);
    }
    async cleanupOrphanedSchedules() {
        try {
            console.log('Running daily cleanup of orphaned content schedules');
            const orphanedSchedules = await this.repo.find({
                where: [
                    { content: { deletedAt: (0, typeorm_2.Not)((0, typeorm_2.IsNull)()) } },
                    { content: (0, typeorm_2.IsNull)() },
                ],
                relations: {
                    content: true,
                },
                withDeleted: true,
            });
            if (orphanedSchedules.length > 0) {
                await this.repo.remove(orphanedSchedules);
                console.log(`Cleanup complete: deleted ${orphanedSchedules.length} orphaned content schedules`, orphanedSchedules.map((schedule) => ({
                    scheduleId: schedule.id,
                    contentId: schedule.contentId,
                })));
            }
            else {
                console.log('No orphaned content schedules found');
            }
        }
        catch (error) {
            console.error('Error during content schedule cleanup:', error);
        }
    }
};
exports.ContentScheduleService = ContentScheduleService;
ContentScheduleService.path = `content_schedules`;
__decorate([
    (0, schedule_1.Cron)('0 0 * * *'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ContentScheduleService.prototype, "cleanupOrphanedSchedules", null);
exports.ContentScheduleService = ContentScheduleService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(content_schedule_entity_1.ContentScheduleEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], ContentScheduleService);
//# sourceMappingURL=content-schedule.service.js.map