import { BaseCRUDController } from '@serene-dev/la-nest-library/dist/libs/la-library/src/controllers/base.controller';
import { IDDto } from '@serene-dev/la-nest-library';
import { ContentEntity } from './content.entity';
import { ContentService } from './content.service';
import { SearchContentDTO, CreateContentDTO, UpdateContentDTO } from './content.dto';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
export declare class ContentController extends BaseCRUDController<ContentEntity, SearchContentDTO> {
    protected service: ContentService;
    constructor(service: ContentService);
    getByID(param: IDDto, auth: IAuthParam): Promise<string | ContentEntity>;
    search(query: SearchContentDTO, auth?: IAuthParam): Promise<string | import("@serene-dev/la-nest-library").ISearchResponse<ContentEntity>>;
    visibilities(): string | import("@serene-dev/la-nest-library").ValueLabelDto<any>[];
    statuses(): string | import("@serene-dev/la-nest-library").ValueLabelDto<any>[];
    create(body: CreateContentDTO, auth: IAuthParam): string | Promise<ContentEntity>;
    updateByID(param: IDDto, body: UpdateContentDTO, auth: IAuthParam): string | Promise<ContentEntity>;
}
