"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const base_controller_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/controllers/base.controller");
const search_dto_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/dtos/search.dto");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const content_service_1 = require("./content.service");
const content_dto_1 = require("./content.dto");
const authentication_enum_1 = require("../../modules/authentication/enums/authentication.enum");
const jwt_auth_guard_1 = require("../../modules/authentication/guards/jwt-auth.guard");
const utility_service_1 = require("../../services/utility.service");
const content_enum_1 = require("../../enums/content.enum");
let ContentController = class ContentController extends base_controller_1.BaseCRUDController {
    constructor(service) {
        super(service);
        this.service = service;
    }
    async getByID(param, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await (auth.userType == authentication_enum_1.EAuthType.public
                    ? this.service.getSingleForPublic({ id: param.id }, auth)
                    : this.service.getSingle({ id: param.id }, auth)),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async search(query, auth) {
        return super.search(query, auth);
    }
    visibilities() {
        return utility_service_1.UtilityClass.returnEnum(content_enum_1.EContentVisibility);
    }
    statuses() {
        return utility_service_1.UtilityClass.returnEnum(content_enum_1.EContentStatus);
    }
    create(body, auth) {
        return super.create(body, auth);
    }
    updateByID(param, body, auth) {
        return super.updateByID(param, body, auth);
    }
};
exports.ContentController = ContentController;
__decorate([
    (0, common_1.Get)('getByID/:id'),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.IDDto, Object]),
    __metadata("design:returntype", Promise)
], ContentController.prototype, "getByID", null);
__decorate([
    (0, common_1.Get)('search'),
    (0, swagger_1.ApiResponse)({ type: search_dto_1.SearchResponseDto }),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [content_dto_1.SearchContentDTO, Object]),
    __metadata("design:returntype", Promise)
], ContentController.prototype, "search", null);
__decorate([
    (0, common_1.Get)('visibilities'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ContentController.prototype, "visibilities", null);
__decorate([
    (0, common_1.Get)('statuses'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ContentController.prototype, "statuses", null);
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [content_dto_1.CreateContentDTO, Object]),
    __metadata("design:returntype", void 0)
], ContentController.prototype, "create", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, jwt_auth_guard_1.Role)(authentication_enum_1.EAuthType.admin),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.IDDto,
        content_dto_1.UpdateContentDTO, Object]),
    __metadata("design:returntype", void 0)
], ContentController.prototype, "updateByID", null);
exports.ContentController = ContentController = __decorate([
    (0, swagger_1.ApiTags)('contents'),
    (0, common_1.Controller)('contents'),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [content_service_1.ContentService])
], ContentController);
//# sourceMappingURL=content.controller.js.map