"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchContentDTO = exports.UpdateContentDTO = exports.CreateContentDTO = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const class_transformer_1 = require("class-transformer");
const content_enum_1 = require("../../enums/content.enum");
const base_entity_1 = require("../../entities/base.entity");
class CreateContentDTO {
}
exports.CreateContentDTO = CreateContentDTO;
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], CreateContentDTO.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateContentDTO.prototype, "description", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], CreateContentDTO.prototype, "releaseDateTime", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], CreateContentDTO.prototype, "releaseDateTimeEnd", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateContentDTO.prototype, "videoId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsUUID)(),
    __metadata("design:type", String)
], CreateContentDTO.prototype, "categoryId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsUUID)(),
    __metadata("design:type", String)
], CreateContentDTO.prototype, "channelId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ enum: content_enum_1.EContentStatus }),
    (0, class_validator_1.IsEnum)(content_enum_1.EContentStatus),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateContentDTO.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: content_enum_1.EContentVisibility }),
    (0, class_validator_1.IsEnum)(content_enum_1.EContentVisibility),
    __metadata("design:type", String)
], CreateContentDTO.prototype, "visibility", void 0);
class UpdateContentDTO extends (0, swagger_1.PartialType)((0, swagger_1.OmitType)(CreateContentDTO, ['releaseDateTime', 'releaseDateTimeEnd'])) {
}
exports.UpdateContentDTO = UpdateContentDTO;
class SearchContentDTO extends (0, swagger_1.IntersectionType)(base_entity_1.SearchQueryDto, UpdateContentDTO) {
}
exports.SearchContentDTO = SearchContentDTO;
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], SearchContentDTO.prototype, "likes", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], SearchContentDTO.prototype, "dislikes", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchContentDTO.prototype, "providerId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchContentDTO.prototype, "categoryName", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchContentDTO.prototype, "channelName", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchContentDTO.prototype, "providerName", void 0);
//# sourceMappingURL=content.dto.js.map