import { Relation } from 'typeorm';
import { VideoEntity } from '../video/video.entity';
import { BaseEntity } from '../../entities/base.entity';
import { EContentStatus, EContentVisibility } from '../../enums/content.enum';
import { PosterEntity } from '../poster/poster.entity';
import { ContentScheduleEntity } from '../content-schedule/content-schedule.entity';
import { ChannelEntity } from '../channel/channel.entity';
import { ContentCategoryEntity } from '../content-category/content-category.entity';
export declare class ContentEntity extends BaseEntity {
    name: string;
    description?: string;
    status: EContentStatus;
    visibility: EContentVisibility;
    video?: Relation<VideoEntity>;
    videoId?: string;
    category?: Relation<ContentCategoryEntity>;
    categoryId: string;
    schedules?: Relation<ContentScheduleEntity[]>;
    channel?: Relation<ChannelEntity>;
    channelId: string;
    posters?: Relation<PosterEntity[]>;
}
