"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentEntity = void 0;
const typeorm_1 = require("typeorm");
const base_enum_1 = require("../../enums/base.enum");
const video_entity_1 = require("../video/video.entity");
const base_entity_1 = require("../../entities/base.entity");
const content_enum_1 = require("../../enums/content.enum");
const poster_entity_1 = require("../poster/poster.entity");
const content_schedule_entity_1 = require("../content-schedule/content-schedule.entity");
const channel_entity_1 = require("../channel/channel.entity");
const content_category_entity_1 = require("../content-category/content-category.entity");
const tableName = base_enum_1.ETableName.contents;
let ContentEntity = class ContentEntity extends base_entity_1.BaseEntity {
};
exports.ContentEntity = ContentEntity;
__decorate([
    (0, typeorm_1.Column)({ type: 'nvarchar', length: 255 }),
    __metadata("design:type", String)
], ContentEntity.prototype, "name", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], ContentEntity.prototype, "description", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: 'enum',
        enum: content_enum_1.EContentStatus,
        default: content_enum_1.EContentStatus.in_review,
    }),
    __metadata("design:type", String)
], ContentEntity.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: 'enum',
        enum: content_enum_1.EContentVisibility,
        default: content_enum_1.EContentVisibility.private,
    }),
    __metadata("design:type", String)
], ContentEntity.prototype, "visibility", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => video_entity_1.VideoEntity, (i) => i.contents),
    __metadata("design:type", Object)
], ContentEntity.prototype, "video", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], ContentEntity.prototype, "videoId", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => content_category_entity_1.ContentCategoryEntity, (i) => i.contents),
    __metadata("design:type", Object)
], ContentEntity.prototype, "category", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], ContentEntity.prototype, "categoryId", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => content_schedule_entity_1.ContentScheduleEntity, (i) => i.content),
    __metadata("design:type", Object)
], ContentEntity.prototype, "schedules", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => channel_entity_1.ChannelEntity, (i) => i.contents),
    __metadata("design:type", Object)
], ContentEntity.prototype, "channel", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], ContentEntity.prototype, "channelId", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => poster_entity_1.PosterEntity, (i) => i.content),
    __metadata("design:type", Object)
], ContentEntity.prototype, "posters", void 0);
exports.ContentEntity = ContentEntity = __decorate([
    (0, typeorm_1.Entity)(tableName)
], ContentEntity);
//# sourceMappingURL=content.entity.js.map