import { Repository, FindOptionsWhere } from 'typeorm';
import { BaseService } from '../../services/base.service';
import { ContentEntity } from './content.entity';
import { SearchContentDTO, CreateContentDTO } from './content.dto';
import { IAuthParam } from '../authentication/interfaces/authentication.interface';
import { ISearchResponse } from '@serene-dev/la-nest-library';
import { ContentScheduleService } from '../content-schedule/content-schedule.service';
import { SubscriptionService } from '../subscription/subscription.service';
export declare class ContentService extends BaseService<ContentEntity, SearchContentDTO> {
    repo: Repository<ContentEntity>;
    contentScheduleService: ContentScheduleService;
    subscriptionService: SubscriptionService;
    static path: string;
    constructor(repo: Repository<ContentEntity>, contentScheduleService: ContentScheduleService, subscriptionService: SubscriptionService);
    getSingle(where: FindOptionsWhere<ContentEntity>, auth?: IAuthParam): Promise<ContentEntity>;
    getSingleForPublic(where: FindOptionsWhere<ContentEntity>, auth: IAuthParam): Promise<ContentEntity>;
    protected _postDeletionFunction(ids: string[]): Promise<void>;
    search({ name, channelName, categoryName, description, providerName, ...query }: SearchContentDTO, auth?: IAuthParam): Promise<ISearchResponse<ContentEntity>>;
    protected _postCreateFunction(requestData: CreateContentDTO, savedData: ContentEntity): Promise<void>;
}
