"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const base_service_1 = require("../../services/base.service");
const content_entity_1 = require("./content.entity");
const utility_service_1 = require("../../services/utility.service");
const base_enum_1 = require("../../enums/base.enum");
const content_schedule_service_1 = require("../content-schedule/content-schedule.service");
const subscription_service_1 = require("../subscription/subscription.service");
let ContentService = class ContentService extends base_service_1.BaseService {
    constructor(repo, contentScheduleService, subscriptionService) {
        super(repo, base_enum_1.ETableName.contents);
        this.repo = repo;
        this.contentScheduleService = contentScheduleService;
        this.subscriptionService = subscriptionService;
    }
    async getSingle(where, auth) {
        const r = await this.repo.findOne({
            where,
            relations: {
                category: true,
                video: true,
                channel: { provider: true },
            },
        });
        return r;
    }
    async getSingleForPublic(where, auth) {
        const r = await this.repo.findOne({
            where,
            relations: {
                category: true,
                video: true,
                channel: { provider: true },
            },
        });
        if (!r)
            return r;
        const access = await this.subscriptionService.userHasAccess(auth.id, {
            contentId: r.id,
        });
        if (!access) {
            r['noAccess'] = true;
            delete r.videoId;
            delete r.video;
        }
        return r;
    }
    async _postDeletionFunction(ids) {
        await this.contentScheduleService.repo.softDelete({ contentId: (0, typeorm_2.In)(ids) });
    }
    search({ name, channelName, categoryName, description, providerName, ...query }, auth) {
        return utility_service_1.UtilityClass.searchView(this.repo, query, {
            baseWhere: {
                name: utility_service_1.UtilityClass.likeFormatter(name),
                description: utility_service_1.UtilityClass.likeFormatter(description),
                channel: {
                    name: utility_service_1.UtilityClass.likeFormatter(channelName),
                    provider: { name: utility_service_1.UtilityClass.likeFormatter(providerName) },
                },
                category: { name: utility_service_1.UtilityClass.likeFormatter(categoryName) },
            },
            baseRelations: {
                channel: {
                    provider: true,
                },
                category: true,
            },
        });
    }
    async _postCreateFunction(requestData, savedData) {
        if (requestData.releaseDateTime)
            await this.contentScheduleService._create({
                contentId: savedData.id,
                releaseDateTime: requestData.releaseDateTime,
                releaseDateTimeEnd: requestData.releaseDateTimeEnd,
            });
    }
};
exports.ContentService = ContentService;
ContentService.path = `contents`;
exports.ContentService = ContentService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(content_entity_1.ContentEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        content_schedule_service_1.ContentScheduleService,
        subscription_service_1.SubscriptionService])
], ContentService);
//# sourceMappingURL=content.service.js.map