import { BaseCRUDController } from '@serene-dev/la-nest-library/dist/libs/la-library/src/controllers/base.controller';
import { IDDto } from '@serene-dev/la-nest-library';
import { PosterEntity } from './poster.entity';
import { PosterQueryDto, PostersQueryDto, PosterUploadDto, SearchPosterDTO, UpdatePosterDTO } from './poster.dto';
import { PosterService } from './poster.service';
import { IAuthParam } from '../authentication/interfaces/authentication.interface';
import { Response } from 'express';
export declare class PosterController extends BaseCRUDController<PosterEntity, SearchPosterDTO> {
    protected service: PosterService;
    constructor(service: PosterService);
    search(query: SearchPosterDTO, auth?: IAuthParam): Promise<string | import("@serene-dev/la-nest-library").ISearchResponse<PosterEntity>>;
    getImages(query: PostersQueryDto, auth?: IAuthParam): Promise<string | {
        content?: import("typeorm").Relation<import("../content/content.entity").ContentEntity>;
        contentId?: string;
        file?: import("typeorm").Relation<import("../storage/storage.entity").StorageMetadataEntity>;
        fileId?: string;
        video?: import("typeorm").Relation<import("../video/video.entity").VideoEntity>;
        videoId?: string;
        name: string;
        provider?: import("typeorm").Relation<import("../../entities/partner.entity").PartnerEntity>;
        providerId?: string;
        channel?: import("typeorm").Relation<import("../channel/channel.entity").ChannelEntity>;
        channelId?: string;
        width?: number;
        height?: number;
        isPortrait?: boolean;
        lastUpdateID?: string;
        id?: string;
        meta?: any;
        createdAt?: string;
        active?: boolean;
        deletedAt?: Date;
        updatedAt?: string;
        creatorId?: string;
        updaterId?: string;
        creator?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        updater?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        orgID?: string;
        order?: number;
        url: string;
    }[]>;
    getImage(query: PosterQueryDto, auth?: IAuthParam): Promise<string | {
        content?: import("typeorm").Relation<import("../content/content.entity").ContentEntity>;
        contentId?: string;
        file?: import("typeorm").Relation<import("../storage/storage.entity").StorageMetadataEntity>;
        fileId?: string;
        video?: import("typeorm").Relation<import("../video/video.entity").VideoEntity>;
        videoId?: string;
        name: string;
        provider?: import("typeorm").Relation<import("../../entities/partner.entity").PartnerEntity>;
        providerId?: string;
        channel?: import("typeorm").Relation<import("../channel/channel.entity").ChannelEntity>;
        channelId?: string;
        width?: number;
        height?: number;
        isPortrait?: boolean;
        lastUpdateID?: string;
        id?: string;
        meta?: any;
        createdAt?: string;
        active?: boolean;
        deletedAt?: Date;
        updatedAt?: string;
        creatorId?: string;
        updaterId?: string;
        creator?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        updater?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        orgID?: string;
        order?: number;
        url: string;
    }>;
    getURLRedirect(query: PosterQueryDto, res: Response, auth?: IAuthParam): Promise<never>;
    uploadFile(file: Express.Multer.File, body: PosterUploadDto, auth: IAuthParam): Promise<string | PosterEntity>;
    updateByID(param: IDDto, body: UpdatePosterDTO, auth: IAuthParam): string | Promise<PosterEntity>;
}
