"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PosterController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const base_controller_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/controllers/base.controller");
const search_dto_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/dtos/search.dto");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const poster_dto_1 = require("./poster.dto");
const poster_service_1 = require("./poster.service");
const jwt_auth_guard_1 = require("../authentication/guards/jwt-auth.guard");
const authentication_enum_1 = require("../authentication/enums/authentication.enum");
const platform_express_1 = require("@nestjs/platform-express");
const utility_service_1 = require("../../services/utility.service");
let PosterController = class PosterController extends base_controller_1.BaseCRUDController {
    constructor(service) {
        super(service);
        this.service = service;
    }
    async search(query, auth) {
        return super.search(query, auth);
    }
    async getImages(query, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getURLs(query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getImage(query, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getURL(query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getURLRedirect(query, res, auth) {
        try {
            const url = await this.service.getURLRedirect(query);
            if (url)
                res.redirect(url);
            else
                res.status(404).json({ message: 'No Media' });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async uploadFile(file, body, auth) {
        try {
            const result = await this.service.uploadFile(file, body, auth);
            return utility_service_1.UtilityClass.handleSuccess({ data: result });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    updateByID(param, body, auth) {
        return super.updateByID(param, body, auth);
    }
};
exports.PosterController = PosterController;
__decorate([
    (0, common_1.Get)('search'),
    (0, swagger_1.ApiResponse)({ type: search_dto_1.SearchResponseDto }),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [poster_dto_1.SearchPosterDTO, Object]),
    __metadata("design:returntype", Promise)
], PosterController.prototype, "search", null);
__decorate([
    (0, common_1.Get)('urls'),
    (0, la_nest_library_1.SDKPublicAuth)(),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [poster_dto_1.PostersQueryDto, Object]),
    __metadata("design:returntype", Promise)
], PosterController.prototype, "getImages", null);
__decorate([
    (0, common_1.Get)('url'),
    (0, la_nest_library_1.SDKPublicAuth)(),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [poster_dto_1.PosterQueryDto, Object]),
    __metadata("design:returntype", Promise)
], PosterController.prototype, "getImage", null);
__decorate([
    (0, common_1.Get)('url/redirect'),
    (0, la_nest_library_1.SDKPublicAuth)(),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [poster_dto_1.PosterQueryDto, Object, Object]),
    __metadata("design:returntype", Promise)
], PosterController.prototype, "getURLRedirect", null);
__decorate([
    (0, common_1.Post)('upload'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file')),
    (0, swagger_1.ApiConsumes)('multipart/form-data'),
    __param(0, (0, common_1.UploadedFile)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, poster_dto_1.PosterUploadDto, Object]),
    __metadata("design:returntype", Promise)
], PosterController.prototype, "uploadFile", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, jwt_auth_guard_1.Role)(authentication_enum_1.EAuthType.admin),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.IDDto,
        poster_dto_1.UpdatePosterDTO, Object]),
    __metadata("design:returntype", void 0)
], PosterController.prototype, "updateByID", null);
exports.PosterController = PosterController = __decorate([
    (0, swagger_1.ApiTags)(poster_service_1.PosterService.tag),
    (0, common_1.Controller)(poster_service_1.PosterService.path),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [poster_service_1.PosterService])
], PosterController);
//# sourceMappingURL=poster.controller.js.map